/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.Hash;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.logging.Log;
import tdb.cmdline.CmdTDB;

public class tdbnode
extends CmdTDB {
    public static void main(String ... argv) {
        Log.setLog4j();
        new tdbnode(argv).mainRun();
    }

    protected tdbnode(String[] argv) {
        super(argv);
    }

    protected String getSummary() {
        return this.getCommandName() + " NodeId ...";
    }

    protected void exec() {
        GraphTDB graph = this.getGraph();
        NodeTable nodeTable = graph.getNodeTupleTable().getNodeTable();
        Iterator<String> iter = super.getPositional().iterator();
        if (!iter.hasNext()) {
            System.err.println("No node ids");
            return;
        }
        while (iter.hasNext()) {
            String id = iter.next();
            try {
                long x = Long.parseLong(id);
                NodeId nodeId = new NodeId(x);
                Node n = nodeTable.getNodeForNodeId(nodeId);
                Hash h = new Hash(16);
                NodeLib.setHash(h, n);
                String str2 = Bytes.asHex(h.getBytes());
                System.out.printf("%s %08d 0x%s # %s\n", id, x, str2, n);
            }
            catch (Exception ex) {
                System.out.println("Failed to decode: " + id);
            }
        }
    }
}

