/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.Map;
import org.openjena.riot.system.IRIResolver;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.system.PrefixMap2;

public class Prologue {
    protected boolean seenBaseURI = false;
    protected PrefixMap prefixMap = null;
    protected IRIResolver resolver = null;

    public static Prologue create(String base, PrefixMapping pmapping) {
        PrefixMap pmap = null;
        if (pmapping != null) {
            pmap = new PrefixMap();
            Map<String, String> x = pmapping.getNsPrefixMap();
            for (Map.Entry<String, String> e2 : x.entrySet()) {
                pmap.add(e2.getKey(), e2.getValue());
            }
        }
        IRIResolver resolver = null;
        if (base != null) {
            resolver = IRIResolver.create(base);
        }
        return new Prologue(pmap, resolver);
    }

    public Prologue() {
        this.prefixMap = new PrefixMap();
        this.resolver = null;
    }

    public Prologue(PrefixMap pmap, IRIResolver resolver) {
        this.prefixMap = pmap;
        this.resolver = resolver;
    }

    public Prologue(Prologue other) {
        this.prefixMap = other.prefixMap;
        this.resolver = other.resolver;
    }

    public Prologue copy() {
        PrefixMap prefixMap = new PrefixMap(this.prefixMap);
        return new Prologue(prefixMap, this.resolver);
    }

    public void usePrologueFrom(Prologue other) {
        this.prefixMap = new PrefixMap(other.prefixMap);
        this.seenBaseURI = false;
        if (other.resolver != null) {
            this.resolver = IRIResolver.create(other.resolver.getBaseIRIasString());
        }
    }

    public Prologue sub(PrefixMap newMappings) {
        return this.sub(newMappings, null);
    }

    public Prologue sub(String base) {
        return this.sub(null, base);
    }

    public Prologue sub(PrefixMap newMappings, String base) {
        PrefixMap ext = this.getPrefixMap();
        if (newMappings != null) {
            ext = new PrefixMap2(ext);
        }
        IRIResolver r = this.resolver;
        if (base != null) {
            r = IRIResolver.create(base);
        }
        return new Prologue(ext, r);
    }

    public boolean explicitlySetBaseURI() {
        return this.seenBaseURI;
    }

    public String getBaseURI() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.getBaseIRIasString();
    }

    public void setBaseURI(String baseURI) {
        this.seenBaseURI = true;
        this.resolver = IRIResolver.create(baseURI);
    }

    public void setBaseURI(IRI iri2) {
        this.seenBaseURI = true;
        this.resolver = IRIResolver.create(iri2);
    }

    public void setBaseURI(IRIResolver resolver) {
        this.seenBaseURI = true;
        this.resolver = resolver;
    }

    public void setPrefix(String prefix, String expansion) {
        this.prefixMap.add(prefix, expansion);
    }

    public PrefixMap getPrefixMap() {
        return this.prefixMap;
    }

    public void setPrefixMapping(PrefixMap pmap) {
        this.prefixMap = pmap;
    }

    public IRIResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(IRIResolver resolver) {
        this.resolver = resolver;
    }
}

