/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline.normalize;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import java.util.HashMap;
import java.util.Map;
import org.openjena.riot.LangTag;
import org.openjena.riot.pipeline.normalize.DatatypeHandler;
import org.openjena.riot.pipeline.normalize.NormalizeValue;

public class CanonicalizeLiteral
implements NodeTransform {
    private static final CanonicalizeLiteral singleton = new CanonicalizeLiteral();
    private static final Map<RDFDatatype, DatatypeHandler> dispatch = new HashMap<RDFDatatype, DatatypeHandler>();

    public static CanonicalizeLiteral get() {
        return singleton;
    }

    private CanonicalizeLiteral() {
    }

    public Node convert(Node node) {
        Node n2;
        RDFDatatype dt = node.getLiteralDatatype();
        if (dt == null) {
            if (node.getLiteralLanguage().equals("")) {
                return node;
            }
            n2 = CanonicalizeLiteral.canonicalLangtag(node, node.getLiteralLexicalForm(), node.getLiteralLanguage());
        } else {
            DatatypeHandler handler = dispatch.get(dt);
            if (handler == null) {
                return node;
            }
            n2 = handler.handle(node, node.getLiteralLexicalForm(), dt);
        }
        if (n2 == null) {
            return node;
        }
        return n2;
    }

    private static Node canonicalLangtag(Node node, String lexicalForm, String langTag) {
        String langTag2 = LangTag.canonical(langTag);
        if (langTag2.equals(langTag)) {
            return null;
        }
        return Node.createLiteral(lexicalForm, langTag2, null);
    }

    static {
        dispatch.put(XSDDatatype.XSDinteger, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDdecimal, NormalizeValue.dtDecimal);
        dispatch.put(XSDDatatype.XSDint, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDlong, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDshort, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDbyte, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDunsignedInt, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDunsignedLong, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDunsignedShort, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDunsignedByte, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDnonPositiveInteger, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDnonNegativeInteger, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDpositiveInteger, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDnegativeInteger, NormalizeValue.dtInteger);
        dispatch.put(XSDDatatype.XSDfloat, NormalizeValue.dtFloat);
        dispatch.put(XSDDatatype.XSDdouble, NormalizeValue.dtDouble);
        dispatch.put(XSDDatatype.XSDdateTime, NormalizeValue.dtDateTime);
        dispatch.put(XSDDatatype.XSDduration, null);
        dispatch.put(XSDDatatype.XSDboolean, NormalizeValue.dtBoolean);
    }
}

