/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import org.openjena.riot.out.OutputLangUtils;

public class RiotWriter {
    public static void writeNQuads(PrintStream out, DatasetGraph dsg) {
        OutputStreamWriter w;
        try {
            w = new OutputStreamWriter((OutputStream)out, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return;
        }
        RiotWriter.outputOneGraph(w, dsg.getDefaultGraph(), null);
        Iterator<Node> iterGraphs = dsg.listGraphNodes();
        while (iterGraphs.hasNext()) {
            Node gn = iterGraphs.next();
            RiotWriter.outputOneGraph(w, dsg.getGraph(gn), gn);
        }
        try {
            ((Writer)w).flush();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static void outputOneGraph(Writer w, Graph graph, Node graphNode) {
        ExtendedIterator<Triple> iter = graph.find(null, null, null);
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            OutputLangUtils.output(w, triple, graphNode, null);
        }
    }
}

