/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.validation;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.fuseki.Fuseki;
import org.slf4j.Logger;

public abstract class ValidatorBase
extends HttpServlet {
    protected static Logger serviceLog = Fuseki.serverlog;
    public static final String cssFile = "/fuseki.css";
    public static final String respService = "X-Service";

    @Override
    public void init() throws ServletException {
        super.init();
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.execute(httpRequest, httpResponse);
    }

    @Override
    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.execute(httpRequest, httpResponse);
    }

    protected abstract void execute(HttpServletRequest var1, HttpServletResponse var2);

    protected static void setHeaders(HttpServletResponse httpResponse) {
        httpResponse.setCharacterEncoding("UTF-8");
        httpResponse.setContentType("text/html");
        httpResponse.setHeader(respService, "Fuseki/ARQ SPARQL Query Validator: http://openjena.org/ARQ");
    }

    protected static String htmlQuote(String str2) {
        StringBuffer sBuff = new StringBuffer();
        block5: for (int i = 0; i < str2.length(); ++i) {
            char ch = str2.charAt(i);
            switch (ch) {
                case '<': {
                    sBuff.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sBuff.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sBuff.append("&amp;");
                    continue block5;
                }
                default: {
                    sBuff.append(ch);
                }
            }
        }
        return sBuff.toString();
    }

    protected static void startFixed(ServletOutputStream outStream) throws IOException {
        outStream.println("<pre class=\"box\">");
    }

    protected static void columns(String prefix, ServletOutputStream outStream) throws IOException {
        outStream.print(prefix);
        outStream.println("         1         2         3         4         5         6         7");
        outStream.print(prefix);
        outStream.println("12345678901234567890123456789012345678901234567890123456789012345678901234567890");
    }

    protected static void finishFixed(ServletOutputStream outStream) throws IOException {
        outStream.println("</pre>");
    }

    protected static void printHead(ServletOutputStream outStream, String title) throws IOException {
        outStream.println("<head>");
        outStream.println(" <title>" + title + "</title>");
        outStream.println(" <link rel=\"stylesheet\" type=\"text/css\" href=\"/fuseki.css\" />");
        outStream.println("</head>");
    }
}

