/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.validation;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.fuseki.validation.ValidatorBase;

public class QueryValidator
extends ValidatorBase {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramQuery = "query";
    static final String paramSyntax = "languageSyntax";

    @Override
    protected void execute(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Content c;
            SerializationContext sCxt;
            Op op;
            Syntax language;
            String[] args = httpRequest.getParameterValues(paramQuery);
            if (args == null || args.length == 0) {
                httpResponse.sendError(400, "No query parameter to validator");
                return;
            }
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many query parameters");
                return;
            }
            String queryString = httpRequest.getParameter(paramQuery).replaceAll("(\r|\n| )*$", "");
            String querySyntax = httpRequest.getParameter(paramSyntax);
            if (querySyntax == null || querySyntax.equals("")) {
                querySyntax = "SPARQL";
            }
            if ((language = Syntax.lookup(querySyntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + querySyntax);
                return;
            }
            String lineNumbersArg = httpRequest.getParameter(paramLineNumbers);
            String[] a = httpRequest.getParameterValues(paramFormat);
            boolean outputSPARQL = false;
            boolean outputPrefix = false;
            boolean outputAlgebra = false;
            boolean outputQuads = false;
            if (a != null) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i].equals("sparql")) {
                        outputSPARQL = true;
                    }
                    if (a[i].equals("prefix")) {
                        outputPrefix = true;
                    }
                    if (a[i].equals("algebra")) {
                        outputAlgebra = true;
                    }
                    if (!a[i].equals("quads")) continue;
                    outputQuads = true;
                }
            }
            boolean lineNumbers = true;
            if (lineNumbersArg != null) {
                lineNumbers = lineNumbersArg.equalsIgnoreCase("true") || lineNumbersArg.equalsIgnoreCase("yes");
            }
            QueryValidator.setHeaders(httpResponse);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            outStream.println("<html>");
            QueryValidator.printHead(outStream, "SPARQL Query Validation Report");
            outStream.println("<body>");
            outStream.println("<h1>SPARQL Query Validator</h1>");
            outStream.println("<p>Input:</p>");
            Content c2 = new Content(){

                @Override
                public void print(IndentedWriter out) {
                    out.print(queryString);
                }
            };
            this.output(outStream, c2, lineNumbers);
            Query q = null;
            try {
                q = QueryFactory.create(queryString, "http://example/base/", language);
            }
            catch (ARQException ex) {
                outStream.println("<p>Syntax error:</p>");
                QueryValidator.startFixed(outStream);
                outStream.println(ex.getMessage());
                QueryValidator.finishFixed(outStream);
            }
            catch (RuntimeException ex) {
                outStream.println("<p>Internal error:</p>");
                QueryValidator.startFixed(outStream);
                outStream.println(ex.getMessage());
                QueryValidator.finishFixed(outStream);
            }
            Query query2 = q;
            if (query2 != null && outputSPARQL) {
                outStream.println("<p>Formatted, parsed query:</p>");
                Content c3 = new Content(){

                    @Override
                    public void print(IndentedWriter out) {
                        query2.serialize(out);
                    }
                };
                this.output(outStream, c3, lineNumbers);
            }
            if (query2 != null && outputAlgebra) {
                outStream.println("<p>Algebra structure:</p>");
                op = Algebra.compile(query2);
                sCxt = new SerializationContext(query2);
                c = new Content(){

                    @Override
                    public void print(IndentedWriter out) {
                        op.output(out, sCxt);
                    }
                };
                this.output(outStream, c, lineNumbers);
            }
            if (query2 != null && outputQuads) {
                outStream.println("<p>Quad structure:</p>");
                op = Algebra.toQuadForm(Algebra.compile(query2));
                sCxt = new SerializationContext(query2);
                c = new Content(){

                    @Override
                    public void print(IndentedWriter out) {
                        op.output(out, sCxt);
                    }
                };
                this.output(outStream, c, lineNumbers);
            }
            outStream.println("</html>");
        }
        catch (Exception ex) {
            serviceLog.warn("Exception in doGet", ex);
        }
    }

    private void output(ServletOutputStream outStream, Content content, boolean lineNumbers) throws IOException {
        QueryValidator.startFixed(outStream);
        IndentedLineBuffer out = new IndentedLineBuffer(lineNumbers);
        content.print(out);
        out.flush();
        String x = QueryValidator.htmlQuote(out.asString());
        byte[] b = x.getBytes("UTF-8");
        outStream.write(b);
        QueryValidator.finishFixed(outStream);
    }

    static interface Content {
        public void print(IndentedWriter var1);
    }
}

