/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.validation;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkWrapper;
import org.openjena.fuseki.validation.ValidatorBase;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.SysRIOT;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.system.RiotLib;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public class DataValidator
extends ValidatorBase {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramIndirection = "url";
    static final String paramData = "data";
    static final String paramSyntax = "languageSyntax";
    static final long LIMIT = 50000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Lang language;
            Tokenizer tokenizer = this.createTokenizer(httpRequest, httpResponse);
            if (tokenizer == null) {
                return;
            }
            String syntax = httpRequest.getParameter(paramSyntax);
            if (syntax == null || syntax.equals("")) {
                syntax = Lang.NQUADS.getName();
            }
            if ((language = Lang.get(syntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + syntax);
                return;
            }
            ServletOutputStream outStream = httpResponse.getOutputStream();
            ErrorHandlerMsg errorHandler = new ErrorHandlerMsg(outStream);
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(new PrintStream(outStream));
            System.setErr(new PrintStream(outStream));
            DataValidator.setHeaders(httpResponse);
            outStream.println("<html>");
            DataValidator.printHead(outStream, "Jena Data Validator Report");
            outStream.println("<body>");
            outStream.println("<h1>RIOT Parser Report</h1>");
            outStream.println("<p>Line and column numbers refer to original input</p>");
            outStream.println("<p>&nbsp;</p>");
            try {
                LangRIOT parser = this.setupParser(tokenizer, language, errorHandler, outStream);
                DataValidator.startFixed(outStream);
                RiotException exception = null;
                try {
                    parser.parse();
                    System.out.flush();
                    System.err.flush();
                }
                catch (RiotException ex) {
                    exception = ex;
                }
            }
            finally {
                DataValidator.finishFixed(outStream);
                System.out.flush();
                System.err.flush();
                System.setOut(stdout);
                System.setErr(stdout);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (Exception ex) {
            serviceLog.warn("Exception in validationRequest", ex);
        }
    }

    private LangRIOT setupParser(Tokenizer tokenizer, Lang language, ErrorHandler errorHandler, ServletOutputStream outStream) {
        Sink<Quad> sink = new Sink<Quad>(){
            SerializationContext sCxt = new SerializationContext();

            @Override
            public void send(Quad quad) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.formatNode(quad.getSubject()));
                sb.append("  ");
                sb.append(this.formatNode(quad.getPredicate()));
                sb.append("  ");
                sb.append(this.formatNode(quad.getObject()));
                if (!quad.isTriple()) {
                    sb.append("  ");
                    sb.append(this.formatNode(quad.getGraph()));
                }
                String $ = ValidatorBase.htmlQuote(sb.toString());
                try {
                    outStream.print($);
                    outStream.println(" .");
                }
                catch (IOException ex) {
                    IO.exception(ex);
                }
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            String formatNode(Node n) {
                return FmtUtils.stringForNode(n, this.sCxt);
            }
        };
        SinkWrapper<Quad> sink2 = new SinkWrapper<Quad>((Sink)sink){
            long count;
            {
                this.count = 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public void flush() {
            }

            @Override
            public void send(Quad quad) {
                super.send(quad);
                ++this.count;
                if (this.count > 50000L) {
                    throw new RiotException("Limit exceeded");
                }
            }
        };
        LangRIOT parser = RiotReader.createParserQuads(tokenizer, language, null, sink);
        parser.setProfile(RiotLib.profile(null, false, true, errorHandler));
        return parser;
    }

    private Tokenizer createTokenizer(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        Reader reader = null;
        String[] args = httpRequest.getParameterValues(paramIndirection);
        if (args == null || args.length == 0) {
            reader = httpRequest.getReader();
        } else if (args.length > 1) {
            httpResponse.sendError(400, "Too many parameters for 'url='");
            return null;
        }
        args = httpRequest.getParameterValues(paramData);
        if (args != null && args.length != 0) {
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many parameters for 'data='");
                return null;
            }
            reader = new StringReader(args[0]);
        }
        if (reader == null) {
            httpResponse.sendError(400, "Can't find data to validate");
            return null;
        }
        return TokenizerFactory.makeTokenizer(reader);
    }

    private static class ErrorHandlerMsg
    implements ErrorHandler {
        private ServletOutputStream out;

        ErrorHandlerMsg(ServletOutputStream out) {
            this.out = out;
        }

        @Override
        public void warning(String message, long line, long col) {
            this.output(message, line, col, "Warning", "warning");
        }

        @Override
        public void error(String message, long line, long col) {
            this.output(message, line, col, "Error", "error");
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.output(message, line, col, "Fatal", "error");
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        private void output(String message, long line, long col, String typeName, String className) {
            try {
                String str2 = SysRIOT.fmtMessage(message, line, col);
                str2 = ValidatorBase.htmlQuote(str2);
                this.out.print("<div class=\"" + className + "\">");
                this.out.print(str2);
                this.out.print("</div>");
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }
    }
}

