/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.openjena.atlas.lib.Sink;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.FusekiLib;
import org.openjena.fuseki.conneg.ContentType;
import org.openjena.fuseki.server.DatasetRegistry;
import org.openjena.fuseki.servlets.ActionErrorException;
import org.openjena.fuseki.servlets.HttpAction;
import org.openjena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.openjena.riot.system.IRIResolver;

public class SPARQL_Upload
extends SPARQL_ServletBase {
    private static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(Fuseki.serverlog);

    public SPARQL_Upload(boolean verbose_debug) {
        super(SPARQL_ServletBase.PlainRequestFlag.REGULAR, verbose_debug);
    }

    @Override
    protected String mapRequestToDataset(String uri) {
        String uri2 = this.mapRequestToDataset(uri, "/upload");
        if (uri2 != null && !"".equals(uri2)) {
            return uri2;
        }
        if (DatasetRegistry.get().size() == 1) {
            return DatasetRegistry.get().keys().next();
        }
        return null;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionUpload action = new HttpActionUpload(id, dsg, request, response, this.verbose_debug);
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (!isMultipart) {
            SPARQL_Upload.error(400, "Not a file upload");
        }
        ServletFileUpload upload = new ServletFileUpload();
        try {
            String graphName = null;
            Graph graphTmp = GraphFactory.createGraphMem();
            Node gn = null;
            String name = null;
            ContentType ct = null;
            Lang lang = null;
            int tripleCount = 0;
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String fieldName = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    String value = Streams.asString(stream);
                    if (fieldName.equals("graph")) {
                        graphName = value;
                        if (graphName == null || graphName.equals("default")) continue;
                        IRI iri2 = IRIResolver.parseIRI(value);
                        if (iri2.hasViolation(false)) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: " + graphName);
                        }
                        if (iri2.getScheme() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no IRI scheme name: " + graphName);
                        }
                        if (iri2.getRawHost() == null) {
                            SPARQL_Upload.errorBadRequest("Bad IRI: no host name: " + graphName);
                        }
                        if (iri2.getRawPath() != null && iri2.getRawPath().length() > 0 && iri2.getRawPath().charAt(0) != '/') {
                            SPARQL_Upload.errorBadRequest("Bad IRI: Pat does not start '/': " + graphName);
                        }
                        gn = Node.createURI(graphName);
                        continue;
                    }
                    Fuseki.serverlog.info(String.format("[%d] Upload: Field=" + fieldName + " - ignored", new Object[0]));
                    continue;
                }
                name = item.getName();
                String contentTypeHeader = item.getContentType();
                ct = FusekiLib.contentType(contentTypeHeader);
                lang = FusekiLib.langFromContentType(ct.contentType);
                if (lang == null) {
                    lang = Lang.guess(name);
                }
                String base = null;
                SinkTriplesToGraph sink = new SinkTriplesToGraph(graphTmp);
                LangRIOT parser = RiotReader.createParserTriples(stream, lang, base, (Sink<Triple>)sink);
                parser.getProfile().setHandler(errorHandler);
                try {
                    parser.parse();
                }
                catch (RiotException ex) {
                    SPARQL_Upload.errorBadRequest("Parse error: " + ex.getMessage());
                }
                tripleCount = graphTmp.size();
            }
            if (graphName == null) {
                graphName = "default";
            }
            Fuseki.serverlog.info(String.format("[%d] Upload: Filename: %s, Content-Type=%s, Charset=%s => (%s,%s,%d triple(s))", action.id, name, ct.contentType, ct.charset, graphName, lang.getName(), tripleCount));
            action.beginWrite();
            try {
                if (graphName.equals("default")) {
                    dsg.getDefaultGraph().getBulkUpdateHandler().add(graphTmp);
                } else {
                    dsg.getGraph(gn).getBulkUpdateHandler().add(graphTmp);
                }
            }
            finally {
                action.endWrite();
            }
            response.setContentType("text/plain");
            response.getOutputStream().print("Triples = " + tripleCount);
            SPARQL_Upload.success(action);
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SPARQL_Upload.errorOccurred(ex);
            return;
        }
    }

    private void validate(HttpServletRequest request) {
    }

    @Override
    protected boolean requestNoQueryString(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_Upload.errorOccurred("requestNoQueryString");
        return true;
    }

    private class HttpActionUpload
    extends HttpAction {
        public HttpActionUpload(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, dsg, request, response, verbose);
        }
    }
}

