/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Bytes;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.servlets.HttpAction;
import org.openjena.fuseki.servlets.SPARQL_ServletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQL_Update
extends SPARQL_ServletBase {
    private static Logger log = LoggerFactory.getLogger(SPARQL_Update.class);
    private static String updateParseBase = "http://example/base/";

    public SPARQL_Update(boolean verbose) {
        super(SPARQL_ServletBase.PlainRequestFlag.REGULAR, verbose);
    }

    public SPARQL_Update() {
        this(false);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(400, "Attempt to perform SPARQL update by GET.  Use POST");
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected boolean requestNoQueryString(HttpServletRequest request, HttpServletResponse response) {
        if ("POST".equals(request.getMethod().toUpperCase())) {
            return true;
        }
        SPARQL_Update.errorOccurred("Bad!");
        return false;
    }

    @Override
    protected String mapRequestToDataset(String uri) {
        String uri2 = this.mapRequestToDataset(uri, "/update");
        return uri2 != null ? uri2 : uri;
    }

    @Override
    protected void perform(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionUpdate action = new HttpActionUpdate(id, dsg, request, response, this.verbose_debug);
        String incoming = request.getContentType();
        if ("application/sparql-update".equals(incoming)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(incoming)) {
            this.executeForm(action);
            return;
        }
        SPARQL_Update.error(415, "Bad content type: " + incoming);
    }

    private void validate(HttpServletRequest request) {
        String incoming = request.getContentType();
        if ("application/sparql-update".equals(incoming)) {
            Enumeration en;
            if (request.getQueryString() != null) {
                SPARQL_Update.errorBadRequest("No query string allowed: found: " + request.getQueryString());
            }
            if ((en = request.getParameterNames()).hasMoreElements()) {
                SPARQL_Update.errorBadRequest("No request parameters allowed");
            }
            return;
        }
        if ("application/x-www-form-urlencoded".equals(incoming)) {
            String requestStr = request.getParameter("request");
            if (requestStr == null) {
                SPARQL_Update.errorBadRequest("SPARQL Update: No request= in HTML form");
            }
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (name.equals("request")) continue;
                SPARQL_Update.errorBadRequest("SPARQL Update: Unrecognize request parameter: " + name);
            }
            return;
        }
        SPARQL_Update.error(415, "Must be application/sparql-update or application/x-www-form-urlencoded");
    }

    private void executeBody(HttpActionUpdate action) {
        UpdateRequest req;
        ServletInputStream input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            SPARQL_Update.errorOccurred(ex);
        }
        try {
            if (action.verbose) {
                byte[] b = IO.readWholeFile(input);
                String requestStr = Bytes.bytes2string(b);
                String requestStr1 = SPARQL_Update.formatForLog(requestStr);
                Fuseki.serverlog.info(String.format("[%d] Update = %s", action.id, requestStr1));
                req = UpdateFactory.create(requestStr);
            } else {
                req = UpdateFactory.read(input);
            }
        }
        catch (UpdateException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        catch (QueryParseException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        this.execute(action, req);
        SPARQL_Update.successNoContent(action);
    }

    private void executeForm(HttpActionUpdate action) {
        UpdateRequest req;
        String requestStr = action.request.getParameter("request");
        if (action.verbose) {
            Fuseki.serverlog.info(String.format("[%d] Form update = %s", action.id, SPARQL_Update.formatForLog(requestStr)));
        }
        try {
            req = UpdateFactory.create(requestStr, updateParseBase);
        }
        catch (UpdateException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        catch (QueryParseException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
            req = null;
        }
        this.execute(action, req);
        SPARQL_Update.successPage(action, "Update succeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpActionUpdate action, UpdateRequest updateRequest) {
        action.beginWrite();
        try {
            UpdateAction.execute(updateRequest, action.dsg);
        }
        catch (UpdateException ex) {
            SPARQL_Update.errorBadRequest(ex.getMessage());
        }
        finally {
            action.endWrite();
        }
    }

    private class HttpActionUpdate
    extends HttpAction {
        public HttpActionUpdate(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, dsg, request, response, verbose);
        }
    }
}

