/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.http.HttpSC;
import org.openjena.fuseki.server.DatasetRegistry;
import org.openjena.fuseki.servlets.ActionErrorException;
import org.openjena.fuseki.servlets.HttpAction;
import org.openjena.fuseki.servlets.HttpServletResponseTracker;

public abstract class SPARQL_ServletBase
extends HttpServlet {
    protected static AtomicLong requestIdAlloc = new AtomicLong(0L);
    private final PlainRequestFlag noQueryString;
    protected final boolean verbose_debug;

    protected SPARQL_ServletBase(PlainRequestFlag noQueryStringIsOK, boolean verbose_debug) {
        this.noQueryString = noQueryStringIsOK;
        this.verbose_debug = verbose_debug;
    }

    protected void doCommon(HttpServletRequest request, HttpServletResponse response) {
        long id = requestIdAlloc.incrementAndGet();
        this.printRequest(id, request);
        HttpServletResponseTracker responseTracked = new HttpServletResponseTracker(response);
        response = responseTracked;
        String uri = request.getRequestURI();
        SPARQL_ServletBase.setCommonHeaders(response);
        try {
            boolean requestContinue;
            if (request.getQueryString() == null && this.noQueryString == PlainRequestFlag.DIFFERENT && !(requestContinue = this.requestNoQueryString(request, response))) {
                return;
            }
            uri = this.mapRequestToDataset(uri);
            DatasetGraph dsg = (DatasetGraph)DatasetRegistry.get().get(uri);
            if (dsg == null) {
                SPARQL_ServletBase.errorNotFound("No dataset for URI: " + uri);
                return;
            }
            this.perform(id, dsg, request, response);
        }
        catch (ActionErrorException ex) {
            if (ex.exception != null) {
                ex.exception.printStackTrace(System.err);
            }
            if (ex.message != null) {
                this.responseSendError(response, ex.rc, ex.message);
            } else {
                this.responseSendError(response, ex.rc);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            this.responseSendError(response, 500, ex.getMessage());
        }
        this.printResponse(id, responseTracked);
    }

    protected void doPatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405, "HTTP PATCH not supported");
    }

    private void printRequest(long id, HttpServletRequest request) {
        String url = SPARQL_ServletBase.wholeRequestURL(request);
        String method = request.getMethod();
        Fuseki.serverlog.info(String.format("[%d] %s %s", id, method, url));
        if (this.verbose_debug) {
            Enumeration en = request.getHeaderNames();
            while (en.hasMoreElements()) {
                String h = (String)en.nextElement();
                Enumeration vals = request.getHeaders(h);
                if (!vals.hasMoreElements()) {
                    Fuseki.serverlog.info(String.format("[%d]   ", id, h));
                    continue;
                }
                while (vals.hasMoreElements()) {
                    Fuseki.serverlog.info(String.format("[%d]   %-20s %s", id, h, vals.nextElement()));
                }
            }
        }
    }

    private void printResponse(long id, HttpServletResponseTracker response) {
        if (this.verbose_debug) {
            if (response.contentType != null) {
                Fuseki.serverlog.info(String.format("[%d]   %-20s %s", id, "Content-Type", response.contentType));
            }
            if (response.contentLength != -1) {
                Fuseki.serverlog.info(String.format("[%d]   %-20s %d", id, "Content-Length", response.contentLength));
            }
            for (Map.Entry<String, String> e2 : response.headers.entrySet()) {
                Fuseki.serverlog.info(String.format("[%d]   %-20s %s", id, e2.getKey(), e2.getValue()));
            }
        }
        if (response.message == null) {
            Fuseki.serverlog.info(String.format("[%d] %d %s", id, response.statusCode, HttpSC.getMessage(response.statusCode)));
        } else {
            Fuseki.serverlog.info(String.format("[%d] %d %s", id, response.statusCode, response.message));
        }
    }

    private void responseSendError(HttpServletResponse response, int statusCode, String message) {
        try {
            response.sendError(statusCode, message);
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private void responseSendError(HttpServletResponse response, int statusCode) {
        try {
            response.sendError(statusCode);
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    protected abstract String mapRequestToDataset(String var1);

    protected String mapRequestToDataset(String uri, String tail) {
        if (uri.endsWith(tail)) {
            return uri.substring(0, uri.length() - tail.length());
        }
        return null;
    }

    protected abstract void perform(long var1, DatasetGraph var3, HttpServletRequest var4, HttpServletResponse var5);

    protected abstract boolean requestNoQueryString(HttpServletRequest var1, HttpServletResponse var2);

    protected static String wholeRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    protected static void successNoContent(HttpAction action) {
        SPARQL_ServletBase.success(action, 204);
    }

    protected static void success(HttpAction action) {
        SPARQL_ServletBase.success(action, 200);
    }

    protected static void successCreated(HttpAction action) {
        SPARQL_ServletBase.success(action, 201);
    }

    protected static void successNotFound(HttpAction action) {
        SPARQL_ServletBase.success(action, 404);
    }

    protected static void success(HttpAction action, int httpStatusCode) {
        action.response.setStatus(httpStatusCode);
    }

    protected static void successPage(HttpAction action, String message) {
        try {
            action.response.setContentType("text/html");
            action.response.setStatus(200);
            PrintWriter out = action.response.getWriter();
            out.println("<html>");
            out.println("<head>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Success</h1>");
            if (message != null) {
                out.println("<p>");
                out.println(message);
                out.println("</p>");
            }
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    protected static void errorBadRequest(String string) {
        SPARQL_ServletBase.error(400, string);
    }

    protected static void errorNotFound(String string) {
        SPARQL_ServletBase.error(404, string);
    }

    protected static void errorNotImplemented(String msg) {
        SPARQL_ServletBase.error(501, msg);
    }

    protected static void errorMethodNotAllowed(String method) {
        SPARQL_ServletBase.error(405, "HTTP method not allowed: " + method);
    }

    protected static void error(int statusCode) {
        throw new ActionErrorException(null, null, statusCode);
    }

    protected static void error(int statusCode, String string) {
        throw new ActionErrorException(null, string, statusCode);
    }

    protected static void errorOccurred(String message) {
        SPARQL_ServletBase.errorOccurred(message, null);
    }

    protected static void errorOccurred(Throwable ex) {
        SPARQL_ServletBase.errorOccurred(null, ex);
    }

    protected static void errorOccurred(String message, Throwable ex) {
        throw new ActionErrorException(ex, message, 500);
    }

    protected static String formatForLog(String string) {
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        return string;
    }

    public static void setCommonHeaders(HttpServletResponse httpResponse) {
        httpResponse.setHeader("Access-Control-Allow-Origin", "*");
        httpResponse.setHeader("Server", Fuseki.serverHttpName);
    }

    protected static enum PlainRequestFlag {
        REGULAR,
        DIFFERENT;

    }
}

