/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.IOException;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.FusekiLib;
import org.openjena.fuseki.conneg.MediaType;
import org.openjena.fuseki.conneg.TypedOutputStream;
import org.openjena.fuseki.servlets.SPARQL_REST;
import org.openjena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.riot.Lang;

public class SPARQL_REST_R
extends SPARQL_REST {
    public SPARQL_REST_R(boolean verbose) {
        super(verbose);
    }

    public SPARQL_REST_R() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(SPARQL_REST.HttpActionREST action) {
        try {
            if (!action.target.isDefault && !action.dsg.containsGraph(action.target.graphName)) {
                SPARQL_ServletBase.errorNotFound("No such graph: " + action.target.name);
            }
            MediaType mediaType = SPARQL_REST_R.contentNegotationRDF(action);
            TypedOutputStream out = new TypedOutputStream(action.response.getOutputStream(), mediaType);
            Lang lang = FusekiLib.langFromContentType(mediaType.getContentType());
            if (action.verbose) {
                Fuseki.serverlog.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
            }
            action.beginRead();
            try {
                RDFWriter writer = FusekiLib.chooseWriter(lang);
                Model model = ModelFactory.createModelForGraph(action.target.graph());
                writer.write(model, action.response.getOutputStream(), null);
                SPARQL_REST_R.success(action);
            }
            finally {
                action.endRead();
            }
        }
        catch (IOException ex) {
            SPARQL_REST_R.errorOccurred(ex);
        }
    }

    @Override
    protected void doOptions(SPARQL_REST.HttpActionREST action) {
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS");
        action.response.setHeader("Content-Length", "0");
        SPARQL_REST_R.success(action);
    }

    @Override
    protected void doHead(SPARQL_REST.HttpActionREST action) {
        if (!action.target.alreadyExisted) {
            SPARQL_REST_R.successNotFound(action);
            return;
        }
        MediaType mediaType = SPARQL_REST_R.contentNegotationRDF(action);
        SPARQL_REST_R.success(action);
    }

    @Override
    protected void doPost(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("POST");
    }

    @Override
    protected void doDelete(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("DELETE");
    }

    @Override
    protected void doPut(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("PUT");
    }

    @Override
    protected void doPatch(SPARQL_REST.HttpActionREST action) {
        SPARQL_REST_R.errorMethodNotAllowed("PATCH");
    }
}

