/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.atlas.lib.Sink;
import org.openjena.fuseki.DEF;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.FusekiLib;
import org.openjena.fuseki.conneg.ConNeg;
import org.openjena.fuseki.conneg.ContentType;
import org.openjena.fuseki.conneg.MediaType;
import org.openjena.fuseki.servlets.HttpAction;
import org.openjena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerFactory;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.openjena.riot.system.IRIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQL_REST
extends SPARQL_ServletBase {
    protected static Logger classLog = LoggerFactory.getLogger(SPARQL_REST.class);
    protected static ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(Fuseki.serverlog);

    public SPARQL_REST(boolean verbose) {
        super(SPARQL_ServletBase.PlainRequestFlag.DIFFERENT, verbose);
    }

    public SPARQL_REST() {
        this(false);
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doCommon(request, response);
    }

    private void maybeSetLastModified(HttpServletResponse resp, long lastModified) {
        if (resp.containsHeader("Last-Modified")) {
            return;
        }
        if (lastModified >= 0L) {
            resp.setDateHeader("Last-Modified", lastModified);
        }
    }

    @Override
    protected void perform(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response) {
        SPARQL_REST.validate(request);
        HttpActionREST action = new HttpActionREST(id, dsg, request, response, this.verbose_debug);
        this.dispatch(action);
    }

    private void dispatch(HttpActionREST action) {
        HttpServletRequest req = action.request;
        HttpServletResponse resp = action.response;
        String method = req.getMethod().toUpperCase();
        if (method.equals("GET")) {
            this.doGet(action);
        } else if (method.equals("HEAD")) {
            this.doHead(action);
        } else if (method.equals("POST")) {
            this.doPost(action);
        } else if (method.equals("PATCH")) {
            this.doPatch(action);
        } else if (method.equals("OPTIONS")) {
            this.doOptions(action);
        } else if (method.equals("TRACE")) {
            SPARQL_REST.errorMethodNotAllowed("TRACE");
        } else if (method.equals("PUT")) {
            this.doPut(action);
        } else if (method.equals("DELETE")) {
            this.doDelete(action);
        } else {
            SPARQL_REST.errorNotImplemented("Unknown method: " + method);
        }
    }

    protected abstract void doGet(HttpActionREST var1);

    protected abstract void doHead(HttpActionREST var1);

    protected abstract void doPost(HttpActionREST var1);

    protected abstract void doPatch(HttpActionREST var1);

    protected abstract void doDelete(HttpActionREST var1);

    protected abstract void doPut(HttpActionREST var1);

    protected abstract void doOptions(HttpActionREST var1);

    @Override
    protected String mapRequestToDataset(String uri) {
        String uri2 = this.mapRequestToDataset(uri, "/data");
        return uri2 != null ? uri2 : uri;
    }

    @Override
    protected boolean requestNoQueryString(HttpServletRequest request, HttpServletResponse response) {
        SPARQL_REST.errorBadRequest("No query string");
        return false;
    }

    protected static MediaType contentNegotationRDF(HttpActionREST action) {
        MediaType mt = ConNeg.chooseContentType(action.request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    protected static MediaType contentNegotationQuads(HttpServletRequest request) {
        return ConNeg.chooseContentType(request, DEF.quadsOffer, DEF.acceptTriG);
    }

    protected static void deleteGraph(HttpActionREST action) {
        if (action.target.isDefault) {
            action.target.graph().getBulkUpdateHandler().removeAll();
        } else {
            action.dsg.removeGraph(action.target.graphName);
        }
    }

    protected static void clearGraph(Target target) {
        if (target.isGraphSet()) {
            target.graph().getBulkUpdateHandler().removeAll();
        }
    }

    protected static void addDataInto(Graph data, Target dest) {
        Graph g = dest.graph();
        g.getBulkUpdateHandler().add(data);
    }

    protected static DatasetGraph parseBody(HttpActionREST action) {
        String contentTypeHeader = action.request.getContentType();
        ContentType ct = FusekiLib.contentType(contentTypeHeader);
        int len = action.request.getContentLength();
        Lang lang = FusekiLib.langFromContentType(ct.contentType);
        if (lang == null) {
            SPARQL_REST.errorBadRequest("Unknown: " + contentTypeHeader);
            return null;
        }
        if (action.verbose) {
            if (len >= 0) {
                Fuseki.serverlog.info(String.format("[%d]   Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s", action.id, len, ct.contentType, ct.charset, lang.getName()));
            } else {
                Fuseki.serverlog.info(String.format("[%d]   Body: Content-Type=%s, Charset=%s => %s", action.id, ct.contentType, ct.charset, lang.getName()));
            }
        }
        try {
            InputStream input = action.request.getInputStream();
            String base = SPARQL_ServletBase.wholeRequestURL(action.request);
            boolean buffering = false;
            if (buffering) {
                if (len >= 0) {
                    byte[] b = new byte[len];
                    input.read(b);
                    input = new ByteArrayInputStream(b);
                } else {
                    String x = FileUtils.readWholeFileAsUTF8(input);
                    System.out.println(x);
                    input = new ByteArrayInputStream(x.getBytes("UTF-8"));
                }
            }
            return SPARQL_REST.parse(action, lang, base, input);
        }
        catch (IOException ex) {
            SPARQL_REST.errorOccurred(ex);
            return null;
        }
    }

    private static DatasetGraph parse(HttpActionREST action, Lang lang, String base, InputStream input) {
        Graph graphTmp = GraphFactory.createGraphMem();
        SinkTriplesToGraph sink = new SinkTriplesToGraph(graphTmp);
        LangRIOT parser = RiotReader.createParserTriples(input, lang, base, (Sink<Triple>)sink);
        parser.getProfile().setHandler(errorHandler);
        try {
            parser.parse();
        }
        catch (RiotException ex) {
            SPARQL_REST.errorBadRequest("Parse error: " + ex.getMessage());
        }
        DatasetGraph dsgTmp = DatasetGraphFactory.create(graphTmp);
        return dsgTmp;
    }

    protected static void validate(HttpServletRequest request) {
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String h = (String)en.nextElement();
            if (!"graph".equals(h) && !"default".equals(h)) {
                SPARQL_ServletBase.errorBadRequest("Unknown parameter '" + h + "'");
            }
            if (request.getParameterValues(h).length == 1) continue;
            SPARQL_ServletBase.errorBadRequest("Multiple parameters '" + h + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Target targetGraph(HttpServletRequest request, DatasetGraph dsg) {
        boolean dftGraph = SPARQL_REST.getOneOnly(request, "default") != null;
        String uri = SPARQL_REST.getOneOnly(request, "graph");
        if (!dftGraph && uri == null) {
            SPARQL_ServletBase.errorBadRequest("Neither default graph nor named graph specificed");
        }
        if (dftGraph) {
            return Target.createDefault(dsg);
        }
        String base = SPARQL_ServletBase.wholeRequestURL(request);
        String absUri = IRIResolver.resolveString(uri, base);
        Node gn = Node.createURI(absUri);
        dsg.getLock().enterCriticalSection(true);
        try {
            boolean alreadyExists = dsg.containsGraph(gn);
            Target target = Target.createNamed(dsg, alreadyExists, absUri, gn);
            return target;
        }
        finally {
            dsg.getLock().leaveCriticalSection();
        }
    }

    protected static String getOneOnly(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            SPARQL_ServletBase.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }

    protected static final class Target {
        final boolean isDefault;
        final boolean alreadyExisted;
        final DatasetGraph dsg;
        private Graph _graph;
        final String name;
        final Node graphName;

        static Target createNamed(DatasetGraph dsg, boolean alreadyExisted, String name, Node graphName) {
            return new Target(false, dsg, alreadyExisted, name, graphName);
        }

        static Target createDefault(DatasetGraph dsg) {
            return new Target(true, dsg, true, null, null);
        }

        private Target(boolean isDefault, DatasetGraph dsg, boolean alreadyExisted, String name, Node graphName) {
            this.isDefault = isDefault;
            this.alreadyExisted = alreadyExisted;
            this.dsg = dsg;
            this._graph = null;
            this.name = name;
            this.graphName = graphName;
            if (isDefault) {
                if (name != null || graphName != null) {
                    throw new IllegalArgumentException("Inconsistent: default and a graph name/node");
                }
            } else if (name == null || graphName == null) {
                throw new IllegalArgumentException("Inconsistent: not default and/or no graph name/node");
            }
        }

        public Graph graph() {
            if (this.isGraphSet()) {
                this._graph = this.isDefault ? this.dsg.getDefaultGraph() : this.dsg.getGraph(this.graphName);
            }
            return this._graph;
        }

        public boolean isGraphSet() {
            return this._graph == null;
        }

        public String toString() {
            if (this.isDefault) {
                return "default";
            }
            return this.name;
        }
    }

    class HttpActionREST
    extends HttpAction {
        final Target target;

        public HttpActionREST(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, dsg, request, response, verbose);
            this.target = SPARQL_REST.targetGraph(request, dsg);
        }
    }
}

