/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.migrate.WebIO;
import org.openjena.fuseki.servlets.HttpAction;
import org.openjena.fuseki.servlets.ResponseQuery;
import org.openjena.fuseki.servlets.SPARQL_ServletBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQL_Query
extends SPARQL_ServletBase {
    private static Logger log = LoggerFactory.getLogger(SPARQL_Query.class);
    static String[] tails = new String[]{"/query", "/sparql"};

    public SPARQL_Query(boolean verbose) {
        super(SPARQL_ServletBase.PlainRequestFlag.DIFFERENT, verbose);
    }

    public SPARQL_Query() {
        this(false);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doCommon(request, response);
    }

    @Override
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "GET,OPTIONS,POST");
        response.setHeader("Content-Length", "0");
    }

    @Override
    protected void perform(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response) {
        this.validate(request);
        HttpActionQuery action = new HttpActionQuery(id, dsg, request, response, this.verbose_debug);
        if (request.getMethod().equals("GET")) {
            this.executeForm(action);
            return;
        }
        String incoming = request.getContentType();
        if ("application/sparql-query".equals(incoming)) {
            this.executeBody(action);
            return;
        }
        if ("application/x-www-form-urlencoded".equals(incoming)) {
            this.executeForm(action);
            return;
        }
        SPARQL_Query.error(415, "Bad content type: " + incoming);
    }

    @Override
    protected boolean requestNoQueryString(HttpServletRequest request, HttpServletResponse response) {
        if ("POST".equals(request.getMethod().toUpperCase())) {
            return true;
        }
        if (!"GET".equals(request.getMethod().toUpperCase())) {
            SPARQL_Query.errorNotImplemented("Not a GET or POST request");
            return false;
        }
        log.warn("Service Description / SPARQL Query");
        SPARQL_Query.errorNotFound("Service Description");
        return false;
    }

    @Override
    protected String mapRequestToDataset(String uri) {
        for (String tail : tails) {
            String x = this.mapRequestToDataset(uri, tail);
            if (x == null) continue;
            return x;
        }
        return uri;
    }

    protected abstract void validate(HttpServletRequest var1);

    protected void validate(HttpServletRequest request, Set<String> params) {
        String queryStr;
        String incoming = request.getContentType();
        if (incoming != null) {
            if ("application/sparql-query".equals(incoming)) {
                SPARQL_Query.error(415, "Unofficial application/sparql-query not supported");
            }
            if (!"application/x-www-form-urlencoded".equals(incoming)) {
                SPARQL_Query.error(415, "Unsupported: " + incoming);
            }
        }
        if ((queryStr = request.getParameter("query")) == null) {
            SPARQL_Query.errorBadRequest("SPARQL Query: No query specificied (no 'query=' found)");
        }
        if (params != null) {
            Enumeration en = request.getParameterNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                if (params.contains(name)) continue;
                SPARQL_Query.errorBadRequest("SPARQL Query: Unrecognize request parameter: " + name);
            }
        }
    }

    private void executeForm(HttpActionQuery action) {
        String queryString = action.request.getParameter("query");
        this.execute(queryString, action);
    }

    private void executeBody(HttpActionQuery action) {
        String queryString = null;
        try {
            ServletInputStream input = action.request.getInputStream();
            queryString = IO.readWholeFileAsUTF8(input);
        }
        catch (IOException ex) {
            SPARQL_Query.errorOccurred(ex);
        }
        this.execute(queryString, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String queryString, HttpActionQuery action) {
        String queryStringLog = SPARQL_Query.formatForLog(queryString);
        Fuseki.serverlog.info(String.format("[%d] Query = %s", action.id, queryString));
        Query query2 = null;
        try {
            query2 = QueryFactory.create(queryString, Syntax.syntaxARQ);
            queryStringLog = this.formatForLog(query2);
        }
        catch (QueryException ex) {
            SPARQL_Query.errorBadRequest("Parse error: \n" + queryString + "\n\r" + ex.getMessage());
        }
        this.validateQuery(action, query2);
        if (query2.hasDatasetDescription()) {
            SPARQL_Query.errorBadRequest("Query has FROM/FROM NAMED");
        }
        action.beginRead();
        try {
            SPARQLResult result = this.executeQuery(action, query2, queryStringLog);
            this.sendResults(action, result);
        }
        finally {
            action.endWrite();
        }
    }

    protected abstract void validateQuery(HttpActionQuery var1, Query var2);

    protected QueryExecution createQueryExecution(Query query2, Dataset dataset) {
        return QueryExecutionFactory.create(query2, dataset);
    }

    private SPARQLResult executeQuery(HttpActionQuery action, Query query2, String queryStringLog) {
        Dataset dataset = this.decideDataset(action, query2, queryStringLog);
        QueryExecution qexec = this.createQueryExecution(query2, dataset);
        if (query2.isSelectType()) {
            ResultSet rs = qexec.execSelect();
            rs.hasNext();
            Fuseki.serverlog.info(String.format("[%d] OK/select", action.id));
            return new SPARQLResult(rs);
        }
        if (query2.isConstructType()) {
            Model model = qexec.execConstruct();
            Fuseki.serverlog.info(String.format("[%d] OK/construct", action.id));
            return new SPARQLResult(model);
        }
        if (query2.isDescribeType()) {
            Model model = qexec.execDescribe();
            Fuseki.serverlog.info(String.format("[%d] OK/describe", action.id));
            return new SPARQLResult(model);
        }
        if (query2.isAskType()) {
            boolean b = qexec.execAsk();
            Fuseki.serverlog.info(String.format("[%d] OK/ask", action.id));
            return new SPARQLResult(b);
        }
        SPARQL_Query.errorBadRequest("Unknown query type - " + queryStringLog);
        return null;
    }

    protected abstract Dataset decideDataset(HttpActionQuery var1, Query var2, String var3);

    protected void sendResults(HttpActionQuery action, SPARQLResult result) {
        if (result.isResultSet()) {
            ResponseQuery.doResponseResultSet(result.getResultSet(), null, action.request, action.response);
        } else if (result.isGraph()) {
            ResponseQuery.doResponseModel(result.getModel(), action.request, action.response);
        } else if (result.isBoolean()) {
            ResponseQuery.doResponseResultSet(null, result.getBooleanResult(), action.request, action.response);
        } else {
            SPARQL_Query.errorOccurred("Unknown or invalid result type");
        }
    }

    private String formatForLog(Query query2) {
        IndentedLineBuffer out = new IndentedLineBuffer();
        out.setFlatMode(true);
        query2.serialize(out);
        return out.asString();
    }

    private String getRemoteString(String queryURI) {
        return WebIO.exec_get(queryURI);
    }

    protected class HttpActionQuery
    extends HttpAction {
        public HttpActionQuery(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
            super(id, dsg, request, response, verbose);
        }
    }
}

