/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.xmloutput.RDFXMLWriterI;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openjena.fuseki.DEF;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.FusekiException;
import org.openjena.fuseki.FusekiLib;
import org.openjena.fuseki.conneg.AcceptList;
import org.openjena.fuseki.conneg.ConNeg;
import org.openjena.fuseki.conneg.MediaType;
import org.openjena.fuseki.conneg.TypedInputStream;
import org.openjena.fuseki.servlets.SPARQL_ServletBase;
import org.openjena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseQuery {
    private static Logger log = LoggerFactory.getLogger(ResponseQuery.class);
    static AcceptList prefContentTypeResultSet = DEF.rsOffer;
    static AcceptList prefContentTypeRDF = DEF.rdfOffer;
    public static final String contentOutputJSON = "json";
    public static final String contentOutputXML = "xml";
    public static final String contentOutputSPARQL = "sparql";
    public static final String contentOutputText = "text";
    public static final String contentOutputCSV = "csv";
    public static final String contentOutputTSV = "tsv";

    public static void doResponseModel(Model model, HttpServletRequest request, HttpServletResponse response) {
        TypedInputStream ts;
        Lang lang;
        RDFWriter rdfw;
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rdfOffer, DEF.acceptRDFXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        String writerMimeType = mimeType;
        if (mimeType == null) {
            Fuseki.serverlog.warn("Can't find MIME type for response");
            String x = request.getHeader("Accept");
            String msg = x == null ? "No Accept: header" : "Accept: " + x + " : Not understood";
            SPARQL_ServletBase.error(406, msg);
        }
        if ((rdfw = FusekiLib.chooseWriter(lang = FusekiLib.langFromContentType((ts = new TypedInputStream(null, mimeType, "utf-8")).getMediaType()))) instanceof RDFXMLWriterI) {
            rdfw.setProperty("showXmlDeclaration", "true");
        }
        try {
            rdfw.write(model, response.getOutputStream(), null);
            response.getOutputStream().flush();
        }
        catch (Exception ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    public static void doResponseResultSet(ResultSet resultSet, Boolean booleanResult, HttpServletRequest request, HttpServletResponse response) {
        String forceAccept;
        String outputField;
        if (resultSet == null && booleanResult == null) {
            log.warn("doResponseResult: Both result set and boolean result are null");
            throw new FusekiException("Both result set and boolean result are null");
        }
        if (resultSet != null && booleanResult != null) {
            log.warn("doResponseResult: Both result set and boolean result are set");
            throw new FusekiException("Both result set and boolean result are set");
        }
        String mimeType = null;
        MediaType i = ConNeg.chooseContentType(request, DEF.rsOffer, DEF.acceptRSXML);
        if (i != null) {
            mimeType = i.getContentType();
        }
        if ((outputField = ResponseQuery.paramOutput(request)) != null) {
            mimeType = outputField;
        }
        String serializationType = mimeType;
        String contentType = mimeType;
        String stylesheetURL = ResponseQuery.paramStylesheet(request);
        if (stylesheetURL != null && serializationType.equals("application/sparql-results+xml")) {
            contentType = "application/xml";
        }
        if ((forceAccept = ResponseQuery.paramForceAccept(request)) != null) {
            contentType = forceAccept;
        }
        if (serializationType.equals("application/sparql-results+xml")) {
            try {
                ResponseQuery.output(contentType, null, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, resultSet, stylesheetURL);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsXML((OutputStream)out, booleanResult, stylesheetURL);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/XML]" + ex, ex);
            }
            return;
        }
        if (serializationType.equals("application/sparql-results+json")) {
            try {
                ResponseQuery.jsonOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsJSON((OutputStream)out, booleanResult);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/JSON] " + ex, ex);
            }
            return;
        }
        if (serializationType.equals("text/plain")) {
            try {
                ResponseQuery.textOutput(contentType, new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.out((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.out((OutputStream)out, booleanResult);
                        }
                    }
                }, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/Text] " + ex, ex);
            }
            return;
        }
        if (serializationType.equals("text/csv") || serializationType.equals("text/tab-separated-values")) {
            try {
                OutputContent output = serializationType.equals("text/csv") ? new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsCSV((OutputStream)out, booleanResult);
                        }
                    }
                } : new OutputContent(){

                    @Override
                    public void output(ServletOutputStream out) {
                        if (resultSet != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, resultSet);
                        }
                        if (booleanResult != null) {
                            ResultSetFormatter.outputAsTSV((OutputStream)out, booleanResult);
                        }
                    }
                };
                ResponseQuery.textOutput(contentType, output, request, response);
            }
            catch (Exception ex) {
                log.debug("Exception [SELECT/CSV-TSV] " + ex, ex);
            }
            return;
        }
        SPARQL_ServletBase.errorBadRequest("Can't determine output serialization: " + serializationType);
    }

    private static boolean isEOFexception(IOException ioEx) {
        if (ioEx.getClass().getName().equals("org.mortbay.jetty.EofException eofEx")) {
            return true;
        }
        return ioEx instanceof EOFException;
    }

    private static void output(String contentType, String charset, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ResponseQuery.setHttpResponse(httpRequest, httpResponse, contentType, charset);
            httpResponse.setStatus(200);
            ServletOutputStream out = httpResponse.getOutputStream();
            proc.output(out);
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    public static void setHttpResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String contentType, String charset) {
        httpResponse.setHeader("Cache-Control", "no-cache");
        httpResponse.setHeader("Pragma", "no-cache");
        if (contentType != null) {
            if (charset != null) {
                contentType = contentType + "; charset=" + charset;
            }
            log.trace("Content-Type for response: " + contentType);
            httpResponse.setContentType(contentType);
        }
    }

    private static void jsonOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            String callback = ResponseQuery.paramCallback(httpRequest);
            String outputField = ResponseQuery.paramOutput(httpRequest);
            ServletOutputStream out = httpResponse.getOutputStream();
            if (callback != null) {
                out.print(callback);
                out.println("(");
            }
            ResponseQuery.output(contentType, "utf-8", proc, httpRequest, httpResponse);
            if (callback != null) {
                out.print(")");
                out.println();
            }
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private static void textOutput(String contentType, OutputContent proc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            ServletOutputStream out = httpResponse.getOutputStream();
            ResponseQuery.output(contentType, "utf-8", proc, httpRequest, httpResponse);
            out.flush();
            httpResponse.flushBuffer();
        }
        catch (IOException ex) {
            SPARQL_ServletBase.errorOccurred(ex);
        }
    }

    private static String paramForceAccept(HttpServletRequest request) {
        String x = ResponseQuery.fetchParam(request, "force-accept");
        return ResponseQuery.expandShortName(x);
    }

    private static String paramStylesheet(HttpServletRequest request) {
        return ResponseQuery.fetchParam(request, "stylesheet");
    }

    private static String paramOutput(HttpServletRequest request) {
        String x = ResponseQuery.fetchParam(request, "output");
        if (x == null) {
            x = ResponseQuery.fetchParam(request, "format");
        }
        return ResponseQuery.expandShortName(x);
    }

    private static String paramAcceptField(HttpServletRequest request) {
        String acceptField = request.getHeader("Accept");
        String acceptParam = ResponseQuery.fetchParam(request, "accept");
        if (acceptParam != null) {
            acceptField = acceptParam;
        }
        if (acceptField == null) {
            return null;
        }
        return ResponseQuery.expandShortName(acceptField);
    }

    private static String expandShortName(String str2) {
        if (str2 == null) {
            return null;
        }
        if (str2.equalsIgnoreCase(contentOutputJSON)) {
            return "application/sparql-results+json";
        }
        if (str2.equalsIgnoreCase(contentOutputSPARQL)) {
            return "application/sparql-results+xml";
        }
        if (str2.equalsIgnoreCase(contentOutputXML)) {
            return "application/sparql-results+xml";
        }
        if (str2.equalsIgnoreCase(contentOutputText)) {
            return "text/plain";
        }
        if (str2.equalsIgnoreCase(contentOutputCSV)) {
            return "text/csv";
        }
        if (str2.equalsIgnoreCase(contentOutputTSV)) {
            return "text/tab-separated-values";
        }
        return str2;
    }

    private static String paramCallback(HttpServletRequest request) {
        return ResponseQuery.fetchParam(request, "callback");
    }

    private static String fetchParam(HttpServletRequest request, String parameterName) {
        String value = request.getParameter(parameterName);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static interface OutputContent {
        public void output(ServletOutputStream var1);
    }
}

