/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.servlets;

import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.tdb.TDB;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class HttpAction {
    final long id;
    final DatasetGraph dsg;
    final Lock lock;
    final HttpServletRequest request;
    final HttpServletResponse response;
    final boolean verbose;

    public HttpAction(long id, DatasetGraph dsg, HttpServletRequest request, HttpServletResponse response, boolean verbose) {
        this.id = id;
        this.dsg = dsg;
        this.lock = dsg.getLock();
        this.request = request;
        this.response = response;
        this.verbose = verbose;
    }

    public void beginRead() {
        this.enter(this.dsg, this.lock, true);
    }

    public void endRead() {
        this.leave(this.dsg, this.lock, true);
    }

    public void beginWrite() {
        this.enter(this.dsg, this.lock, false);
    }

    public void endWrite() {
        this.sync();
        this.leave(this.dsg, this.lock, false);
    }

    private void enter(DatasetGraph dsg, Lock lock, boolean readLock) {
        if (lock == null) {
            lock = dsg.getLock();
        }
        if (lock == null) {
            return;
        }
        lock.enterCriticalSection(readLock);
    }

    private void leave(DatasetGraph dsg, Lock lock, boolean readLock) {
        if (lock == null) {
            lock = dsg.getLock();
        }
        if (lock == null) {
            return;
        }
        lock.leaveCriticalSection();
    }

    public void sync() {
        TDB.sync(this.dsg);
    }
}

