/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.server;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Utils;
import javax.servlet.http.HttpServlet;
import org.apache.jasper.servlet.JspServlet;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.openjena.atlas.logging.Log;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.mgt.ActionDataset;
import org.openjena.fuseki.server.DatasetRegistry;
import org.openjena.fuseki.servlets.SPARQL_QueryDataset;
import org.openjena.fuseki.servlets.SPARQL_REST_R;
import org.openjena.fuseki.servlets.SPARQL_REST_RW;
import org.openjena.fuseki.servlets.SPARQL_Update;
import org.openjena.fuseki.servlets.SPARQL_Upload;
import org.openjena.fuseki.validation.DataValidator;
import org.openjena.fuseki.validation.QueryValidator;
import org.openjena.fuseki.validation.UpdateValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLServer {
    public static final Logger log;
    private Server server = null;
    private String datasetPath;
    private int port;
    private boolean verbose = false;
    private boolean enableUpdate = false;

    public Server getServer() {
        return this.server;
    }

    public void start() {
        String now2 = Utils.nowAsString();
        Fuseki.serverlog.info(String.format("%s %s", Fuseki.NAME, Fuseki.VERSION));
        String jettyVersion = Server.getVersion();
        Fuseki.serverlog.info(String.format("Jetty %s", jettyVersion));
        Fuseki.serverlog.info(String.format("Dataset = %s", this.datasetPath));
        Fuseki.serverlog.info(String.format("Started %s on port %d", now2, this.server.getConnectors()[0].getPort()));
        try {
            this.server.start();
        }
        catch (Exception ex) {
            log.error("SPARQLServer: Failed to start server: " + ex.getMessage(), ex);
        }
        ServletContextHandler context = (ServletContextHandler)this.server.getHandler();
    }

    public void stop() {
        String now2 = Utils.nowAsString();
        Fuseki.serverlog.info(String.format("Stopped %s on port %d", now2, this.server.getConnectors()[0].getPort()));
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            log.warn("SPARQLServer: Exception while stopping server: " + ex.getMessage(), ex);
        }
    }

    public SPARQLServer(DatasetGraph dsg, String datasetPath, int port, boolean allowUpdate, boolean verbose) {
        this.port = port;
        this.datasetPath = datasetPath;
        this.enableUpdate = allowUpdate;
        this.verbose = verbose;
        this.init(dsg, datasetPath, port);
    }

    public SPARQLServer(DatasetGraph dsg, String datasetPath, int port, boolean allowUpdate) {
        this(dsg, datasetPath, port, allowUpdate, false);
    }

    private void init(DatasetGraph dsg, String datasetPath, int port) {
        String pages;
        if (datasetPath.equals("/")) {
            datasetPath = "";
        } else if (!datasetPath.startsWith("/")) {
            datasetPath = "/" + datasetPath;
        }
        this.server = new Server();
        BlockingChannelConnector connector = new BlockingChannelConnector();
        connector.setPort(port);
        connector.setRequestBufferSize(0x100000);
        this.server.addConnector(connector);
        ServletContextHandler context = new ServletContextHandler(1);
        this.server.setHandler(context);
        MimeTypes mt = new MimeTypes();
        mt.addMimeMapping("rdf", "application/rdf+xml;charset=utf-8");
        mt.addMimeMapping("ttl", "application/turtle;charset=utf-8");
        mt.addMimeMapping("nt", "text/plain;charset=ascii");
        mt.addMimeMapping("nq", "text/nquads;charset=ascii");
        mt.addMimeMapping("trig", "application/trig;charset=utf-8");
        context.setMimeTypes(mt);
        String[] datasets = new String[]{datasetPath};
        DatasetRegistry.get().put(datasetPath, dsg);
        String validationRoot = "/validate";
        boolean installValidators = true;
        boolean installManager = false;
        String string = pages = this.enableUpdate ? Fuseki.PagesAll : Fuseki.PagesPublish;
        if (this.enableUpdate) {
            installManager = true;
        }
        Fuseki.serverlog.info(this.enableUpdate ? "Update enabled" : "Read-only server");
        for (String dsPath : datasets) {
            SPARQL_QueryDataset sparqlQuery = new SPARQL_QueryDataset(this.verbose);
            SPARQL_REST_R sparqlHttp = this.enableUpdate ? new SPARQL_REST_RW(this.verbose) : new SPARQL_REST_R(this.verbose);
            SPARQLServer.addServlet(context, sparqlHttp, dsPath);
            SPARQLServer.addServlet(context, sparqlHttp, dsPath + "/data");
            SPARQLServer.addServlet(context, sparqlQuery, dsPath + "/query");
            SPARQLServer.addServlet(context, sparqlQuery, dsPath + "/sparql");
            if (!this.enableUpdate) continue;
            SPARQL_Update sparqlUpdate = new SPARQL_Update(this.verbose);
            SPARQLServer.addServlet(context, sparqlUpdate, dsPath + "/update");
            SPARQL_Upload sparqlUpload = new SPARQL_Upload(this.verbose);
            SPARQLServer.addServlet(context, sparqlUpload, dsPath + "/upload");
        }
        if (installValidators) {
            QueryValidator validateQuery = new QueryValidator();
            UpdateValidator validateUpdate = new UpdateValidator();
            DataValidator validateData = new DataValidator();
            SPARQLServer.addServlet(context, validateQuery, validationRoot + "/query");
            SPARQLServer.addServlet(context, validateUpdate, validationRoot + "/update");
            SPARQLServer.addServlet(context, validateData, validationRoot + "/data");
        }
        if (installManager) {
            this.server.setHandler(context);
            JspServlet jspServlet = new JspServlet();
            ServletHolder jspContent = new ServletHolder(jspServlet);
            context.setResourceBase(pages);
            SPARQLServer.addServlet(context, jspContent, "*.jsp");
            ActionDataset datasetChooser = new ActionDataset();
            SPARQLServer.addServlet(context, datasetChooser, "/dataset");
        }
        if (installManager || installValidators) {
            String[] files = new String[]{"fuseki.html"};
            context.setWelcomeFiles(files);
            SPARQLServer.addContent(context, "/", pages);
        }
    }

    private static void addContent(ServletContextHandler context, String pathSpec, String pages) {
        DefaultServlet staticServlet = new DefaultServlet();
        ServletHolder staticContent = new ServletHolder(staticServlet);
        staticContent.setInitParameter("resourceBase", pages);
        SPARQLServer.addServlet(context, staticContent, pathSpec);
    }

    private static void addServlet(ServletContextHandler context, HttpServlet servlet, String pathSpec) {
        ServletHolder holder = new ServletHolder(servlet);
        SPARQLServer.addServlet(context, holder, pathSpec);
    }

    private static void addServlet(ServletContextHandler context, ServletHolder holder, String pathSpec) {
        context.addServlet(holder, pathSpec);
    }

    static {
        Log.setLog4j();
        log = LoggerFactory.getLogger(SPARQLServer.class);
    }
}

