/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.server;

import com.hp.hpl.jena.graph.Triple;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangTurtle;
import org.openjena.riot.out.SinkTripleOutput;

public class FileUpload
extends HttpServlet {
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (!isMultipart) {
            response.sendError(400, "Not a file upload");
            return;
        }
        ServletFileUpload upload = new ServletFileUpload();
        try {
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    System.out.println("Form field " + name + " with value " + Streams.asString(stream) + " detected.");
                    continue;
                }
                System.out.println("File field " + name + " with file name " + item.getName() + " detected.");
                response.setContentType("text/plain");
                SinkTripleOutput sink = new SinkTripleOutput(response.getOutputStream());
                LangTurtle parser = RiotReader.createParserTurtle(stream, null, (Sink<Triple>)sink);
                parser.parse();
                response.getOutputStream().println("----------------------");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            response.sendError(500, ex.getMessage());
            return;
        }
    }
}

