/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.mgt;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.fuseki.server.DatasetRegistry;

public class Functions {
    public static String dataset(HttpServletRequest request, String dftValue) {
        String ds = Functions.dataset(request);
        if (ds == null) {
            return dftValue;
        }
        return ds;
    }

    public static String dataset(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return "No session";
        }
        String ds = (String)session.getAttribute("dataset");
        return ds;
    }

    public static String datasetsAsSelectOptions(HttpServletRequest request) {
        StringBuilder buff = new StringBuilder();
        Iterator<String> iter = DatasetRegistry.get().keys();
        while (iter.hasNext()) {
            String name = iter.next();
            buff.append("<option value=\"" + name + "\">" + name + "</option>");
        }
        return buff.toString();
    }

    public static String datasetsAsListItems(HttpServletRequest request) {
        StringBuilder buff = new StringBuilder();
        Iterator<String> iter = DatasetRegistry.get().keys();
        while (iter.hasNext()) {
            String name = iter.next();
            buff.append("  <li>" + name + "</li>");
        }
        return buff.toString();
    }

    public static String prefixes(HttpServletRequest request) {
        String dsName = Functions.dataset(request);
        DatasetGraph dsg = (DatasetGraph)DatasetRegistry.get().get(dsName);
        if (dsg instanceof DatasetGraphTDB) {
            PrefixMapping pmap = ((DatasetGraphTDB)dsg).getPrefixes().getPrefixMapping();
            Prologue prologue = new Prologue(pmap);
            IndentedLineBuffer buff = new IndentedLineBuffer();
            PrologueSerializer.output(buff, prologue);
            buff.append("\n", new Object[0]);
            return buff.asString();
        }
        return "";
    }
}

