/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.http;

import com.hp.hpl.jena.sparql.modify.request.Target;
import com.hp.hpl.jena.sparql.modify.request.UpdateDrop;
import com.hp.hpl.jena.sparql.modify.request.UpdateWriter;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.openjena.atlas.io.IndentedWriter;

public class UpdateRemote {
    public static void executeClear(String serviceURL) {
        UpdateDrop clear = new UpdateDrop(Target.ALL);
        UpdateRemote.execute(clear, serviceURL);
    }

    public static void execute(Update request, String serviceURL) {
        UpdateRemote.execute(new UpdateRequest(request), serviceURL);
    }

    public static void execute(UpdateRequest request, String serviceURL) {
        HttpPost httpPost = new HttpPost(serviceURL);
        ByteArrayOutputStream b_out = new ByteArrayOutputStream();
        IndentedWriter out = new IndentedWriter(b_out);
        UpdateWriter.output(request, out);
        out.flush();
        byte[] bytes = b_out.toByteArray();
        ByteArrayEntity reqEntity = new ByteArrayEntity(bytes);
        reqEntity.setContentType("application/sparql-update");
        reqEntity.setContentEncoding("UTF-8");
        httpPost.setEntity(reqEntity);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpResponse response = httpclient.execute(httpPost);
            int responseCode = response.getStatusLine().getStatusCode();
            String responseMessage = response.getStatusLine().getReasonPhrase();
            if (responseCode == 204) {
                return;
            }
            if (responseCode == 200) {
                return;
            }
            throw new UpdateException(responseCode + " " + responseMessage);
        }
        catch (IOException ex) {
            throw new UpdateException(ex);
        }
    }
}

