/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.conneg;

import java.util.LinkedHashMap;
import java.util.Map;
import org.openjena.atlas.lib.Lib;
import org.openjena.fuseki.conneg.ConNeg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaType {
    private static Logger log = LoggerFactory.getLogger(MediaType.class);
    private String type = null;
    private String subType = null;
    private String charset = null;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public MediaType(MediaType other) {
        this.type = other.type;
        this.subType = other.subType;
        this.params = new LinkedHashMap<String, String>(other.params);
    }

    public MediaType(String string) {
        this.parseOneEntry(string);
    }

    public static MediaType create(String contentType, String charset) {
        MediaType mediaType = new MediaType(contentType);
        mediaType.setParameter("charset", charset);
        return mediaType;
    }

    private void parseOneEntry(String s) {
        String[] x = ConNeg.split(s, ";");
        this.parseAndSetType(x[0]);
        for (int i = 1; i < x.length; ++i) {
            String[] z = ConNeg.split(x[i], "=");
            if (z.length == 2) {
                this.params.put(z[0], z[1]);
                continue;
            }
            log.warn("Duff parameter: " + x[i] + " in " + s);
        }
    }

    private void parseAndSetType(String s) {
        String[] t = ConNeg.split(s, "/");
        this.type = t[0];
        if (t.length > 1) {
            this.subType = t[1];
        }
    }

    public String toHeaderString() {
        StringBuilder b = new StringBuilder();
        b.append(this.type);
        if (this.subType != null) {
            b.append("/").append(this.subType);
        }
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            b.append(";");
            b.append(entry.getKey());
            b.append("=");
            b.append(entry.getValue());
        }
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[");
        b.append(this.type);
        if (this.subType != null) {
            b.append("/").append(this.subType);
        }
        for (String k : this.params.keySet()) {
            String v = this.params.get(k);
            b.append(" ");
            b.append(k);
            b.append("=");
            b.append(v);
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        return Lib.hashCodeObject(this.type, 1) ^ Lib.hashCodeObject(this.subType, 2) ^ Lib.hashCodeObject(this.params, 3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaType)) {
            return false;
        }
        MediaType mt = (MediaType)object;
        return Lib.equal(this.type, mt.type) && Lib.equal(this.subType, mt.subType) && Lib.equal(this.params, mt.params);
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public void setParameter(String name, String value) {
        this.params.put(name, value);
    }

    public String getContentType() {
        if (this.subType == null) {
            return this.type;
        }
        return this.type + "/" + this.subType;
    }

    public String getCharset() {
        return this.getParameter("charset");
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

