/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki.conneg;

import javax.servlet.http.HttpServletRequest;
import org.openjena.fuseki.conneg.AcceptList;
import org.openjena.fuseki.conneg.MediaRange;
import org.openjena.fuseki.conneg.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConNeg {
    private static Logger log = LoggerFactory.getLogger(ConNeg.class);

    public static MediaType match(String headerString, AcceptList offerList) {
        AcceptList l = new AcceptList(headerString);
        return AcceptList.match(l, offerList);
    }

    public static String match(String headerString, String mediaRangeStr) {
        AcceptList l = new AcceptList(headerString);
        MediaRange aItem = new MediaRange(mediaRangeStr);
        MediaRange m = l.match(aItem);
        if (m == null) {
            return null;
        }
        return m.toHeaderString();
    }

    static String[] split(String s, String splitStr) {
        String[] x = s.split(splitStr, 2);
        for (int i = 0; i < x.length; ++i) {
            x[i] = x[i].trim();
        }
        return x;
    }

    public static MediaType chooseCharset(HttpServletRequest httpRequest, AcceptList myPrefs, MediaType defaultMediaType) {
        String a = httpRequest.getHeader("Accept-Charset");
        if (log.isDebugEnabled()) {
            log.debug("Accept-Charset request: " + a);
        }
        MediaType item = ConNeg.choose(a, myPrefs, defaultMediaType);
        if (log.isDebugEnabled()) {
            log.debug("Charset chosen: " + item);
        }
        return item;
    }

    public static MediaType chooseContentType(HttpServletRequest httpRequest, AcceptList myPrefs, MediaType defaultMediaType) {
        String a = httpRequest.getHeader("Accept");
        if (log.isDebugEnabled()) {
            log.debug("Accept request: " + a);
        }
        MediaType item = ConNeg.choose(a, myPrefs, defaultMediaType);
        if (log.isDebugEnabled()) {
            log.debug("Content type chosen: " + item);
        }
        return item;
    }

    private static MediaType choose(String headerString, AcceptList myPrefs, MediaType defaultMediaType) {
        if (headerString == null) {
            return defaultMediaType;
        }
        AcceptList headerList = new AcceptList(headerString);
        if (myPrefs == null) {
            return headerList.first();
        }
        MediaType i = AcceptList.match(headerList, myPrefs);
        if (i == null) {
            return defaultMediaType;
        }
        return i;
    }
}

