/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki;

import org.openjena.fuseki.FusekiException;
import org.openjena.fuseki.FusekiNotFoundException;

public class FusekiRequestException
extends FusekiException {
    private final int statusCode;
    private final String responseMessage;

    public static FusekiRequestException create(int code, String msg) {
        if (code == 404) {
            return new FusekiNotFoundException(msg);
        }
        return new FusekiRequestException(code, msg);
    }

    protected FusekiRequestException(int code, String msg) {
        super(msg);
        this.statusCode = code;
        this.responseMessage = msg;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    public String toString() {
        return "HTTP: " + this.statusCode + " " + this.getMessage();
    }
}

