/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.sparql.util.Convert;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openjena.atlas.lib.MultiMap;
import org.openjena.fuseki.conneg.ContentType;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;

public class FusekiLib {
    private static Model dummy = ModelFactory.createDefaultModel();
    private static Map<String, Lang> mapContentTypeToLang = new HashMap<String, Lang>();

    public static Lang langFromContentType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        return mapContentTypeToLang.get(mimeType.toLowerCase());
    }

    public static ContentType contentType(HttpServletRequest request) {
        return FusekiLib.contentType(request.getHeader("Content-Type"));
    }

    public static ContentType contentType(String x) {
        String[] z;
        if (x == null) {
            return null;
        }
        String[] y = x.split(";");
        if (y.length == 0) {
            return null;
        }
        String contentType = null;
        if (y[0] != null) {
            contentType = y[0].trim();
        }
        String charset = null;
        if (y.length == 2 && y[1] != null && y[1].contains("=") && (z = y[1].split("="))[0].toLowerCase().startsWith("charset")) {
            charset = z[1].trim();
        }
        return new ContentType(contentType, charset);
    }

    public static RDFWriter chooseWriter(Lang lang) {
        if (lang == null) {
            lang = Lang.RDFXML;
        }
        switch (lang) {
            case N3: 
            case TURTLE: 
            case NTRIPLES: 
            case RDFXML: {
                return dummy.getWriter(lang.getName());
            }
        }
        throw new RiotException("Not a triples language: " + (Object)((Object)lang));
    }

    static String fmtRequest(HttpServletRequest request) {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(request.getMethod());
        sbuff.append(" ");
        sbuff.append(Convert.decWWWForm(request.getRequestURL()));
        String qs = request.getQueryString();
        if (qs != null) {
            String tmp = request.getQueryString();
            tmp = Convert.decWWWForm(tmp);
            tmp = tmp.replace('\n', ' ');
            tmp = tmp.replace('\r', ' ');
            sbuff.append("?").append(tmp);
        }
        return sbuff.toString();
    }

    public static MultiMap<String, String> parseQueryString(HttpServletRequest req) {
        MultiMap<String, String> map = MultiMap.createMapList();
        if (req.getQueryString() != null) {
            String[] params = req.getQueryString().split("&");
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                String[] x = p.split("=", 2);
                String name = null;
                String value = null;
                if (x.length == 0) {
                    name = p;
                    value = "";
                } else if (x.length == 1) {
                    name = x[0];
                    value = "";
                } else {
                    name = x[0];
                    value = x[1];
                }
                map.put(name, value);
            }
        }
        return map;
    }

    static {
        mapContentTypeToLang.put("application/rdf+xml", Lang.RDFXML);
        mapContentTypeToLang.put("application/turtle", Lang.TURTLE);
        mapContentTypeToLang.put("text/turtle", Lang.TURTLE);
        mapContentTypeToLang.put("application/x-turtle", Lang.TURTLE);
        mapContentTypeToLang.put("text/plain", Lang.NTRIPLES);
        mapContentTypeToLang.put("application/n-triples", Lang.NTRIPLES);
    }
}

