/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModDatasetAssembler;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBFactory;
import java.io.InputStream;
import org.openjena.atlas.io.IO;
import org.openjena.fuseki.Fuseki;
import org.openjena.fuseki.server.SPARQLServer;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotLoader;
import org.openjena.riot.lang.SinkQuadsToDataset;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.slf4j.Logger;

public class FusekiCmd
extends CmdARQ {
    private static ArgDecl argMem = new ArgDecl(false, "mem");
    private static ArgDecl argAllowUpdate = new ArgDecl(false, "update", "allowUpdate");
    private static ArgDecl argFile = new ArgDecl(true, "file");
    private static ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB");
    private static ArgDecl argTDB = new ArgDecl(true, "loc", "location");
    private static ArgDecl argPort = new ArgDecl(true, "port");
    private static ModDatasetAssembler modDataset = new ModDatasetAssembler();
    private int port = 3030;
    private DatasetGraph dsg;
    private String datasetPath;
    private boolean allowUpdate = false;
    static String argUsage = "[--mem|--desc=AssemblerFile|--file=FILE] [--port PORT] /DatasetPathName";

    public static void main(String ... argv) {
        ARQ.init();
        Fuseki.init();
        new FusekiCmd(argv).mainRun();
    }

    public FusekiCmd(String ... argv) {
        super(argv);
        this.getUsage().startCategory("Fuseki");
        this.addModule(modDataset);
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB, "--loc=DIR", "use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argPort, "--port", "Port number");
        this.add(argAllowUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.modVersion.addClass(TDB.class);
        this.modVersion.addClass(Fuseki.class);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    @Override
    protected void processModulesAndArgs() {
        Dataset ds;
        int x = 0;
        Logger log = Fuseki.serverlog;
        ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
        if (this.contains(argMem)) {
            ++x;
        }
        if (this.contains(argFile)) {
            ++x;
        }
        if (this.contains(assemblerDescDecl)) {
            ++x;
        }
        if (this.contains(argTDB)) {
            ++x;
        }
        TDB.setOptimizerWarningFlag(false);
        if (x > 1) {
            throw new CmdException("Only one of --mem, --file, --loc or --desc");
        }
        if (x == 0) {
            throw new CmdException("Required: one of --mem, --file, --loc or --desc");
        }
        if (this.contains(argMem)) {
            log.info("Dataset: in-memory");
            this.dsg = DatasetGraphFactory.createMem();
        }
        if (this.contains(argFile)) {
            this.dsg = DatasetGraphFactory.createMem();
            String filename = this.getValue(argFile);
            log.info("Dataset: in-memory: load file: " + filename);
            Lang language = Lang.guess(filename);
            if (language == null) {
                throw new CmdException("Can't guess language for file; " + filename);
            }
            InputStream input = IO.openFile(filename);
            if (language.isQuads()) {
                SinkQuadsToDataset sink = new SinkQuadsToDataset(this.dsg);
                RiotLoader.readQuads(input, language, filename, sink);
            } else {
                SinkTriplesToGraph sink = new SinkTriplesToGraph(this.dsg.getDefaultGraph());
                RiotLoader.readTriples(input, language, filename, sink);
            }
        }
        if (this.contains(argMemTDB)) {
            log.info("TDB dataset: in-memory");
            this.dsg = TDBFactory.createDatasetGraph();
        }
        if (this.contains(argTDB)) {
            String dir = this.getValue(argTDB);
            log.info("TDB dataset: directory=" + dir);
            this.dsg = TDBFactory.createDatasetGraph(dir);
        }
        if (this.contains(assemblerDescDecl)) {
            log.info("Dataset from assembler");
            ds = modDataset.createDataset();
            if (ds != null) {
                this.dsg = ds.asDatasetGraph();
            }
        }
        if (this.contains(argPort)) {
            String portStr = this.getValue(argPort);
            try {
                this.port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException ex) {
                throw new CmdException(argPort.getKeyName() + " : bad port number: " + portStr);
            }
        } else {
            ds = modDataset.createDataset();
            if (ds != null) {
                this.dsg = ds.asDatasetGraph();
            }
        }
        if (this.dsg == null) {
            throw new CmdException("No dataset defined: " + argUsage);
        }
        if (this.getPositional().size() == 0) {
            throw new CmdException("No dataset path name given");
        }
        if (this.getPositional().size() > 1) {
            throw new CmdException("Multiple dataset path names given");
        }
        this.datasetPath = this.getPositionalArg(0);
        if (this.datasetPath.length() > 0 && !this.datasetPath.startsWith("/")) {
            throw new CmdException("Dataset path name must begin with a /: " + this.datasetPath);
        }
        this.allowUpdate = this.contains(argAllowUpdate);
    }

    @Override
    protected void exec() {
        SPARQLServer server = new SPARQLServer(this.dsg, this.datasetPath, this.port, this.allowUpdate, super.isVerbose());
        server.start();
        try {
            server.getServer().join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected String getCommandName() {
        return "fuseki";
    }
}

