/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.lib.Metadata;
import com.hp.hpl.jena.sparql.mgt.ARQMgt;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import org.openjena.riot.RIOT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fuseki {
    public static String PATH = "org.openjena.fuseki";
    public static String FusekiIRI = "http://openjena.org/Fuseki";
    public static String PagesPublish = "pages-publish";
    public static String PagesAll = "pages-update";
    private static String metadataLocation = "org/openjena/fuseki/fuseki-properties.xml";
    private static Metadata metadata = Fuseki.initMetadata();
    public static String NAME = "Fuseki";
    public static String VERSION = metadata.get(PATH + ".version", "development");
    public static String BUILD_DATE = metadata.get(PATH + ".build.datetime", "unknown");
    public static String serverHttpName = NAME + " (" + VERSION + ")";
    public static Logger serverlog = LoggerFactory.getLogger(PATH + ".Fuseki");
    private static boolean initialized = false;

    private static Metadata initMetadata() {
        Metadata m = new Metadata();
        m.addMetadata(metadataLocation);
        return m;
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ARQ.init();
        SystemInfo sysInfo = new SystemInfo(FusekiIRI, VERSION, BUILD_DATE);
        ARQMgt.register(PATH + ".system:type=SystemInfo", sysInfo);
        SystemARQ.registerSubSystem(sysInfo);
        RIOT.init();
    }

    static {
        Fuseki.init();
    }
}

