/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.fuseki;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import org.openjena.fuseki.DatasetAccessor;
import org.openjena.fuseki.http.DatasetAdapter;
import org.openjena.fuseki.http.DatasetGraphAccessor;
import org.openjena.fuseki.http.DatasetGraphAccessorBasic;
import org.openjena.fuseki.http.DatasetGraphAccessorHTTP;

public class DatasetAccessorFactory {
    public static DatasetAccessor createHTTP(String serviceURI) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorHTTP(serviceURI));
    }

    public static DatasetAccessor create(DatasetGraph dataset) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorBasic(dataset));
    }

    public static DatasetAccessor create(Dataset dataset) {
        return DatasetAccessorFactory.adapt(new DatasetGraphAccessorBasic(dataset.asDatasetGraph()));
    }

    public static DatasetGraphAccessor make(DatasetGraph dataset) {
        return new DatasetGraphAccessorBasic(dataset);
    }

    private static DatasetAccessor adapt(DatasetGraphAccessor dgu) {
        return new DatasetAdapter(dgu);
    }
}

