/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import com.hp.hpl.jena.n3.turtle.ParserBase;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.lib.Chars;
import org.openjena.atlas.lib.InternalErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrUtils {
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNEQUAL = -9;
    public static final int CMP_INDETERMINATE = 2;

    private StrUtils() {
    }

    public static String strjoinNL(String ... args) {
        return StrUtils.join("\n", args);
    }

    public static String strjoinNL(List<String> args) {
        return StrUtils.join("\n", args);
    }

    public static String strjoin(String sep, String ... args) {
        return StrUtils.join(sep, args);
    }

    public static String strjoin(String sep, List<String> args) {
        return StrUtils.join(sep, args);
    }

    private static String join(String sep, List<String> a) {
        return StrUtils.join(sep, a.toArray(new String[0]));
    }

    private static String join(String sep, String ... a) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return a[0];
        }
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            if (sep != null) {
                sbuff.append(sep);
            }
            sbuff.append(a[i]);
        }
        return sbuff.toString();
    }

    public static int strCompare(String s1, String s2) {
        int x = s1.compareTo(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static int strCompareIgnoreCase(String s1, String s2) {
        int x = s1.compareToIgnoreCase(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new InternalErrorException("String comparison failure");
    }

    public static byte[] asUTF8bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalErrorException("UTF-8 not supported!");
        }
    }

    public static String fromUTF8bytes(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalErrorException("UTF-8 not supported!");
        }
    }

    public static String str(Object x) {
        if (x == null) {
            return "<null>";
        }
        return x.toString();
    }

    public static String[] split(String s, String splitStr) {
        String[] x = s.split(splitStr);
        for (int i = 0; i < x.length; ++i) {
            x[i] = x[i].trim();
        }
        return x;
    }

    public static final boolean contains(String str1, String str2) {
        return str1.contains(str2);
    }

    public static final String replace(String string, String target, String replacement) {
        return string.replace(target, replacement);
    }

    public static String substitute(String str2, Map<String, String> subs) {
        for (Map.Entry<String, String> e2 : subs.entrySet()) {
            String param = e2.getKey();
            if (!str2.contains(param)) continue;
            str2 = str2.replace(param, e2.getValue());
        }
        return str2;
    }

    public static String strform(Map<String, String> subs, String ... args) {
        return StrUtils.substitute(StrUtils.strjoinNL(args), subs);
    }

    public static String chop(String x) {
        if (x.length() == 0) {
            return x;
        }
        return x.substring(0, x.length() - 1);
    }

    public static String noNewlineEnding(String x) {
        while (x.endsWith("\n") || x.endsWith("\r")) {
            x = StrUtils.chop(x);
        }
        return x;
    }

    public static List<Character> toCharList(String str2) {
        ArrayList<Character> characters = new ArrayList<Character>(str2.length());
        char[] arr$ = str2.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character ch = Character.valueOf(arr$[i$]);
            characters.add(ch);
        }
        return characters;
    }

    public static String encodeHex(String str2, char marker, char[] escapees) {
        int idx;
        int N = str2.length();
        block0: for (idx = 0; idx < N; ++idx) {
            char ch = str2.charAt(idx);
            for (int j = 0; j < escapees.length; ++j) {
                if (ch == escapees[j]) break block0;
            }
        }
        if (idx == N) {
            return str2;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str2, 0, idx);
        while (idx < N) {
            int j;
            char ch = str2.charAt(idx);
            for (j = 0; j < escapees.length; ++j) {
                if (ch != escapees[j]) continue;
                Chars.encodeAsHex(buff, marker, ch);
                break;
            }
            if (j >= escapees.length) {
                buff.append(ch);
            }
            ++idx;
        }
        return buff.toString();
    }

    private static int hexDecode(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static String decodeHex(String str2, char marker) {
        int idx = str2.indexOf(marker);
        if (idx == -1) {
            return str2;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(str2, 0, idx);
        int N = str2.length();
        while (idx < N) {
            char ch = str2.charAt(idx);
            if (ch != marker) {
                buff.append(ch);
            } else {
                char hi = str2.charAt(idx + 1);
                char lo = str2.charAt(idx + 2);
                char ch2 = (char)(StrUtils.hexDecode(hi) << 4 | StrUtils.hexDecode(lo));
                buff.append(ch2);
                idx += 2;
            }
            ++idx;
        }
        return buff.toString();
    }

    public static String escapeString(String x) {
        return FmtUtils.stringEsc(x);
    }

    public static String unescapeString(String x) {
        return ParserBase.unescapeStr(x);
    }
}

