/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.security.SecureRandom;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractSessionIdManager
extends AbstractLifeCycle
implements SessionIdManager {
    private static final String __NEW_SESSION_ID = "org.eclipse.jetty.server.newSessionId";
    protected Random _random;
    protected boolean _weakRandom;
    protected String _workerName;

    public AbstractSessionIdManager() {
    }

    public AbstractSessionIdManager(Random random) {
        this._random = random;
    }

    public String getWorkerName() {
        return this._workerName;
    }

    public void setWorkerName(String workerName) {
        this._workerName = workerName;
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
        this._weakRandom = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String newSessionId(HttpServletRequest request, long created) {
        AbstractSessionIdManager abstractSessionIdManager = this;
        synchronized (abstractSessionIdManager) {
            if (request != null) {
                String cluster_id;
                String requested_id = request.getRequestedSessionId();
                if (requested_id != null && this.idInUse(cluster_id = this.getClusterId(requested_id))) {
                    return cluster_id;
                }
                String new_id = (String)request.getAttribute(__NEW_SESSION_ID);
                if (new_id != null && this.idInUse(new_id)) {
                    return new_id;
                }
            }
            String id = null;
            while (id == null || id.length() == 0 || this.idInUse(id)) {
                long r1;
                long r0;
                long l = r0 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                if (r0 < 0L) {
                    r0 = -r0;
                }
                long l2 = r1 = this._weakRandom ? (long)this.hashCode() ^ Runtime.getRuntime().freeMemory() ^ (long)this._random.nextInt() ^ (long)request.hashCode() << 32 : this._random.nextLong();
                if (r1 < 0L) {
                    r1 = -r1;
                }
                id = Long.toString(r0, 36) + Long.toString(r1, 36);
                if (this._workerName == null) continue;
                id = this._workerName + id;
            }
            request.setAttribute(__NEW_SESSION_ID, id);
            return id;
        }
    }

    protected void doStart() throws Exception {
        this.initRandom();
    }

    protected void doStop() throws Exception {
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
            }
            catch (Exception e2) {
                Log.warn("Could not generate SecureRandom for session-id randomness", e2);
                this._random = new Random();
                this._weakRandom = true;
            }
        }
        this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
    }
}

