/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.eclipse.jetty.io.nio.JVMBUG_THRESHHOLD", 512);
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.eclipse.jetty.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.eclipse.jetty.io.nio.MAX_SELECTS", 25000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.eclipse.jetty.io.nio.BUSY_PAUSE", 50);
    private static final int __BUSY_KEY = Integer.getInteger("org.eclipse.jetty.io.nio.BUSY_KEY", -1);
    private static final int __IDLE_TICK = Integer.getInteger("org.eclipse.jetty.io.nio.IDLE_TICK", 400);
    private int _maxIdleTime;
    private int _lowResourcesMaxIdleTime;
    private long _lowResourcesConnections;
    private SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = (int)maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public SelectSet getSelectSet(int i) {
        return this._selectSet[i];
    }

    public void register(SocketChannel channel, Object att) {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel, att);
            set.wakeup();
        }
    }

    public void register(SocketChannel channel) {
        int s = this._set++;
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange(channel);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) {
        int s = this._set++;
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange(acceptChannel);
        set.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = (int)lowResourcesMaxIdleTime;
    }

    public void doSelect(int acceptorID) throws IOException {
        SelectSet[] sets = this._selectSet;
        if (sets != null && sets.length > acceptorID && sets[acceptorID] != null) {
            sets[acceptorID].doSelect();
        }
    }

    public abstract boolean dispatch(Runnable var1);

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (SelectSet set : sets) {
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract void endPointUpgraded(ConnectedEndPoint var1, Connection var2);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    public void dump() {
        for (final SelectSet set : this._selectSet) {
            StackTraceElement[] trace;
            Thread selecting = set._selecting;
            Log.info("SelectSet " + set._setID + " : " + selecting);
            if (selecting != null && (trace = selecting.getStackTrace()) != null) {
                for (StackTraceElement e2 : trace) {
                    Log.info("\tat " + e2.toString());
                }
            }
            set.addChange(new Runnable(){

                public void run() {
                    set.dump();
                }
            });
        }
    }

    private static class ChannelAndAttachment {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChannelAndAttachment(SelectableChannel channel, Object attachment) {
            this._channel = channel;
            this._attachment = attachment;
        }
    }

    public class SelectSet {
        private final int _setID;
        private final Timeout _timeout;
        private final ConcurrentLinkedQueue<Object> _changes = new ConcurrentLinkedQueue();
        private Selector _selector;
        private volatile Thread _selecting;
        private int _jvmBug;
        private int _selects;
        private long _monitorStart;
        private long _monitorNext;
        private boolean _pausing;
        private SelectionKey _busyKey;
        private int _busyKeyCount;
        private long _log;
        private int _paused;
        private int _jvmFix0;
        private int _jvmFix1;
        private int _jvmFix2;
        private volatile long _idleTick;
        private ConcurrentMap<SelectChannelEndPoint, Object> _endPoints = new ConcurrentHashMap<SelectChannelEndPoint, Object>();

        SelectSet(int acceptorID) throws Exception {
            this._setID = acceptorID;
            this._idleTick = System.currentTimeMillis();
            this._timeout = new Timeout(this);
            this._timeout.setDuration(0L);
            this._selector = Selector.open();
            this._monitorStart = System.currentTimeMillis();
            this._monitorNext = this._monitorStart + (long)__MONITOR_PERIOD;
            this._log = this._monitorStart + 60000L;
        }

        public void addChange(Object change) {
            this._changes.add(change);
        }

        public void addChange(SelectableChannel channel, Object att) {
            if (att == null) {
                this.addChange(channel);
            } else if (att instanceof EndPoint) {
                this.addChange(att);
            } else {
                this.addChange(new ChannelAndAttachment(channel, att));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doSelect() throws IOException {
            try {
                Object change;
                this._selecting = Thread.currentThread();
                Selector selector = this._selector;
                int changes = this._changes.size();
                while (changes-- > 0 && (change = this._changes.poll()) != null) {
                    try {
                        if (change instanceof EndPoint) {
                            SelectChannelEndPoint endpoint = (SelectChannelEndPoint)change;
                            endpoint.doUpdateKey();
                            continue;
                        }
                        if (change instanceof ChannelAndAttachment) {
                            ChannelAndAttachment asc = (ChannelAndAttachment)change;
                            SelectableChannel channel = asc._channel;
                            Object att = asc._attachment;
                            SelectionKey key = channel.register(selector, 1, att);
                            SelectChannelEndPoint endpoint = this.createEndPoint((SocketChannel)channel, key);
                            key.attach(endpoint);
                            endpoint.schedule();
                            continue;
                        }
                        if (change instanceof SocketChannel) {
                            SocketChannel channel = (SocketChannel)change;
                            SelectionKey key = channel.register(selector, 1, null);
                            SelectChannelEndPoint endpoint = this.createEndPoint(channel, key);
                            key.attach(endpoint);
                            endpoint.schedule();
                            continue;
                        }
                        if (change instanceof Runnable) {
                            SelectorManager.this.dispatch((Runnable)change);
                            continue;
                        }
                        throw new IllegalArgumentException(change.toString());
                    }
                    catch (Exception e2) {
                        if (SelectorManager.this.isRunning()) {
                            Log.warn(e2);
                            continue;
                        }
                        Log.debug(e2);
                    }
                    catch (Error e3) {
                        if (SelectorManager.this.isRunning()) {
                            Log.warn(e3);
                            continue;
                        }
                        Log.debug(e3);
                    }
                }
                int selected = selector.selectNow();
                ++this._selects;
                long now2 = System.currentTimeMillis();
                if (selected == 0) {
                    long wait;
                    if (this._pausing) {
                        try {
                            Thread.sleep(__BUSY_PAUSE);
                        }
                        catch (InterruptedException e4) {
                            Log.ignore(e4);
                        }
                        now2 = System.currentTimeMillis();
                    }
                    this._timeout.setNow(now2);
                    long to_next_timeout = this._timeout.getTimeToNext();
                    long l = wait = this._changes.size() == 0 ? (long)__IDLE_TICK : 0L;
                    if (wait > 0L && to_next_timeout >= 0L && wait > to_next_timeout) {
                        wait = to_next_timeout;
                    }
                    if (wait > 0L) {
                        long before = now2;
                        selected = selector.select(wait);
                        ++this._selects;
                        now2 = System.currentTimeMillis();
                        this._timeout.setNow(now2);
                        this.checkJvmBugs(before, now2, wait, selected);
                    }
                }
                if (this._selector == null || !selector.isOpen()) {
                    return;
                }
                for (SelectionKey key : selector.selectedKeys()) {
                    try {
                        if (!key.isValid()) {
                            key.cancel();
                            SelectChannelEndPoint endpoint = (SelectChannelEndPoint)key.attachment();
                            if (endpoint == null) continue;
                            endpoint.doUpdateKey();
                            continue;
                        }
                        Object att = key.attachment();
                        if (att instanceof SelectChannelEndPoint) {
                            ((SelectChannelEndPoint)att).schedule();
                        } else {
                            SocketChannel channel = (SocketChannel)key.channel();
                            SelectChannelEndPoint endpoint = this.createEndPoint(channel, key);
                            key.attach(endpoint);
                            if (key.isReadable()) {
                                endpoint.schedule();
                            }
                        }
                        key = null;
                    }
                    catch (CancelledKeyException e5) {
                        Log.ignore(e5);
                    }
                    catch (Exception e6) {
                        if (SelectorManager.this.isRunning()) {
                            Log.warn(e6);
                        } else {
                            Log.ignore(e6);
                        }
                        if (key == null || key.channel() instanceof ServerSocketChannel || !key.isValid()) continue;
                        key.cancel();
                    }
                }
                selector.selectedKeys().clear();
                now2 = System.currentTimeMillis();
                this._timeout.setNow(now2);
                Timeout.Task task = this._timeout.expired();
                while (task != null) {
                    if (task instanceof Runnable) {
                        SelectorManager.this.dispatch((Runnable)((Object)task));
                    }
                    task = this._timeout.expired();
                }
                if (now2 - this._idleTick > (long)__IDLE_TICK) {
                    this._idleTick = now2;
                    final long idle_now = SelectorManager.this._lowResourcesConnections > 0L && (long)selector.keys().size() > SelectorManager.this._lowResourcesConnections ? now2 + (long)SelectorManager.this._maxIdleTime - (long)SelectorManager.this._lowResourcesMaxIdleTime : now2;
                    SelectorManager.this.dispatch(new Runnable(){

                        public void run() {
                            for (SelectChannelEndPoint endp : SelectSet.this._endPoints.keySet()) {
                                endp.checkIdleTimestamp(idle_now);
                            }
                        }
                    });
                }
            }
            catch (CancelledKeyException e7) {
                Log.ignore(e7);
            }
            finally {
                this._selecting = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkJvmBugs(long before, long now2, long wait, int selected) throws IOException {
            Selector selector = this._selector;
            if (selector == null) {
                return;
            }
            if (now2 > this._monitorNext) {
                this._selects = (int)((long)(this._selects * __MONITOR_PERIOD) / (now2 - this._monitorStart));
                boolean bl = this._pausing = this._selects > __MAX_SELECTS;
                if (this._pausing) {
                    ++this._paused;
                }
                this._selects = 0;
                this._jvmBug = 0;
                this._monitorStart = now2;
                this._monitorNext = now2 + (long)__MONITOR_PERIOD;
            }
            if (now2 > this._log) {
                if (this._paused > 0) {
                    Log.debug(this + " Busy selector - injecting delay " + this._paused + " times");
                }
                if (this._jvmFix2 > 0) {
                    Log.debug(this + " JVM BUG(s) - injecting delay" + this._jvmFix2 + " times");
                }
                if (this._jvmFix1 > 0) {
                    Log.debug(this + " JVM BUG(s) - recreating selector " + this._jvmFix1 + " times, cancelled keys " + this._jvmFix0 + " times");
                } else if (Log.isDebugEnabled() && this._jvmFix0 > 0) {
                    Log.debug(this + " JVM BUG(s) - cancelled keys " + this._jvmFix0 + " times");
                }
                this._paused = 0;
                this._jvmFix2 = 0;
                this._jvmFix1 = 0;
                this._jvmFix0 = 0;
                this._log = now2 + 60000L;
            }
            if (selected == 0 && wait > 10L && now2 - before < wait / 2L) {
                ++this._jvmBug;
                if (this._jvmBug > __JVMBUG_THRESHHOLD) {
                    try {
                        if (this._jvmBug == __JVMBUG_THRESHHOLD + 1) {
                            ++this._jvmFix2;
                        }
                        Thread.sleep(__BUSY_PAUSE);
                    }
                    catch (InterruptedException e2) {
                        Log.ignore(e2);
                    }
                } else {
                    if (this._jvmBug == __JVMBUG_THRESHHOLD) {
                        SelectSet e2 = this;
                        synchronized (e2) {
                            Selector new_selector = Selector.open();
                            for (SelectionKey k : selector.keys()) {
                                if (!k.isValid() || k.interestOps() == 0) continue;
                                SelectableChannel channel = k.channel();
                                Object attachment = k.attachment();
                                if (attachment == null) {
                                    this.addChange(channel);
                                    continue;
                                }
                                this.addChange(channel, attachment);
                            }
                            this._selector.close();
                            this._selector = new_selector;
                            return;
                        }
                    }
                    if (this._jvmBug % 32 == 31) {
                        int cancelled = 0;
                        for (SelectionKey k : selector.keys()) {
                            if (!k.isValid() || k.interestOps() != 0) continue;
                            k.cancel();
                            ++cancelled;
                        }
                        if (cancelled > 0) {
                            ++this._jvmFix0;
                        }
                        return;
                    }
                }
            } else if (__BUSY_KEY > 0 && selected == 1 && this._selects > __MAX_SELECTS) {
                SelectionKey busy = selector.selectedKeys().iterator().next();
                if (busy == this._busyKey) {
                    if (++this._busyKeyCount > __BUSY_KEY && !(busy.channel() instanceof ServerSocketChannel)) {
                        final SelectChannelEndPoint endpoint = (SelectChannelEndPoint)busy.attachment();
                        Log.warn("Busy Key " + busy.channel() + " " + endpoint);
                        busy.cancel();
                        if (endpoint != null) {
                            SelectorManager.this.dispatch(new Runnable(){

                                public void run() {
                                    try {
                                        endpoint.close();
                                    }
                                    catch (IOException e2) {
                                        Log.ignore(e2);
                                    }
                                }
                            });
                        }
                    }
                } else {
                    this._busyKeyCount = 0;
                }
                this._busyKey = busy;
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._timeout.getNow();
        }

        public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
            if (!(task instanceof Runnable)) {
                throw new IllegalArgumentException("!Runnable");
            }
            this._timeout.schedule(task, timeoutMs);
        }

        public void cancelTimeout(Timeout.Task task) {
            task.cancel();
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        private SelectChannelEndPoint createEndPoint(SocketChannel channel, SelectionKey sKey) throws IOException {
            SelectChannelEndPoint endp = SelectorManager.this.newEndPoint(channel, this, sKey);
            SelectorManager.this.endPointOpened(endp);
            this._endPoints.put(endp, this);
            return endp;
        }

        public void destroyEndPoint(SelectChannelEndPoint endp) {
            this._endPoints.remove(endp);
            SelectorManager.this.endPointClosed(endp);
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            try {
                for (int i = 0; i < 100 && this._selecting != null; ++i) {
                    this.wakeup();
                    Thread.sleep(1L);
                }
            }
            catch (Exception e2) {
                Log.ignore(e2);
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                for (SelectionKey key : this._selector.keys()) {
                    Object att;
                    if (key == null || !((att = key.attachment()) instanceof EndPoint)) continue;
                    EndPoint endpoint = (EndPoint)att;
                    try {
                        endpoint.close();
                    }
                    catch (IOException e3) {
                        Log.ignore(e3);
                    }
                }
                this._timeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException e4) {
                    Log.ignore(e4);
                }
                this._selector = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump() {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                Selector selector = this._selector;
                Log.info("SelectSet " + this._setID + " " + selector.keys().size());
                for (SelectionKey key : selector.keys()) {
                    if (key.isValid()) {
                        Log.info(key.channel() + " " + key.interestOps() + " " + key.readyOps() + " " + key.attachment());
                        continue;
                    }
                    Log.info(key.channel() + " - - " + key.attachment());
                }
            }
        }
    }
}

