/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.resource.Resource;

public interface HttpContent {
    public Buffer getContentType();

    public Buffer getLastModified();

    public Buffer getIndirectBuffer();

    public Buffer getDirectBuffer();

    public Resource getResource();

    public long getContentLength();

    public InputStream getInputStream() throws IOException;

    public void release();

    public static class ResourceAsHttpContent
    implements HttpContent {
        final Resource _resource;
        final Buffer _mimeType;

        public ResourceAsHttpContent(Resource resource, Buffer mimeType) {
            this._resource = resource;
            this._mimeType = mimeType;
        }

        public Buffer getContentType() {
            return this._mimeType;
        }

        public Buffer getLastModified() {
            return null;
        }

        public Buffer getDirectBuffer() {
            return null;
        }

        public Buffer getIndirectBuffer() {
            try {
                ByteArrayBuffer buffer = new ByteArrayBuffer((int)this._resource.length());
                buffer.readFrom(this._resource.getInputStream(), (int)this._resource.length());
                return buffer;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        public long getContentLength() {
            return this._resource.length();
        }

        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        public Resource getResource() {
            return this._resource;
        }

        public void release() {
            this._resource.release();
        }
    }
}

