/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.tool.EclipseFileManager;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class EclipseCompilerImpl
extends Main {
    private static final CompilationUnit[] NO_UNITS = new CompilationUnit[0];
    private HashMap<CompilationUnit, JavaFileObject> javaFileObjectMap;
    Iterable<? extends JavaFileObject> compilationUnits;
    public JavaFileManager fileManager;
    protected Processor[] processors;
    public DiagnosticListener<? super JavaFileObject> diagnosticListener;

    public EclipseCompilerImpl(PrintWriter out, PrintWriter err, boolean systemExitWhenFinished) {
        super(out, err, systemExitWhenFinished, null, null);
    }

    public boolean call() {
        try {
            try {
                if (this.proceed) {
                    this.globalProblemsCount = 0;
                    this.globalErrorsCount = 0;
                    this.globalWarningsCount = 0;
                    this.globalTasksCount = 0;
                    this.exportedClassFilesCounter = 0;
                    this.performCompilation();
                }
            }
            catch (IllegalArgumentException e2) {
                this.logger.logException(e2);
                if (this.systemExitWhenFinished) {
                    this.cleanup();
                    System.exit(-1);
                }
                this.cleanup();
                return false;
            }
            catch (RuntimeException e3) {
                this.logger.logException(e3);
                this.cleanup();
                return false;
            }
        }
        finally {
            this.cleanup();
        }
        return this.globalErrorsCount == 0;
    }

    private void cleanup() {
        this.logger.flush();
        this.logger.close();
        this.processors = null;
        try {
            if (this.fileManager != null) {
                this.fileManager.flush();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        if (this.compilationUnits == null) {
            return NO_UNITS;
        }
        ArrayList<1> units = new ArrayList<1>();
        for (final JavaFileObject javaFileObject : this.compilationUnits) {
            if (javaFileObject.getKind() != JavaFileObject.Kind.SOURCE) {
                throw new IllegalArgumentException();
            }
            String name = javaFileObject.getName();
            name = name.replace('\\', '/');
            CompilationUnit compilationUnit = new CompilationUnit(null, name, null){

                @Override
                public char[] getContents() {
                    try {
                        return javaFileObject.getCharContent(true).toString().toCharArray();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        throw new AbortCompilationUnit(null, e2, null);
                    }
                }
            };
            units.add(compilationUnit);
            this.javaFileObjectMap.put(compilationUnit, javaFileObject);
        }
        CompilationUnit[] compilationUnitArray = new CompilationUnit[units.size()];
        units.toArray(compilationUnitArray);
        return compilationUnitArray;
    }

    @Override
    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            @Override
            public boolean proceedOnErrors() {
                return false;
            }

            @Override
            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    @Override
    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(){

            @Override
            public CategorizedProblem createProblem(final char[] originatingFileName, final int problemId, final String[] problemArguments, String[] messageArguments, final int severity, final int startPosition, final int endPosition, final int lineNumber, final int columnNumber) {
                DiagnosticListener<? super JavaFileObject> diagListener = EclipseCompilerImpl.this.diagnosticListener;
                if (diagListener != null) {
                    diagListener.report((Diagnostic<? super JavaFileObject>)new Diagnostic<JavaFileObject>(){

                        @Override
                        public String getCode() {
                            return Integer.toString(problemId);
                        }

                        @Override
                        public long getColumnNumber() {
                            return columnNumber;
                        }

                        @Override
                        public long getEndPosition() {
                            return endPosition;
                        }

                        @Override
                        public Diagnostic.Kind getKind() {
                            if ((severity & 1) != 0) {
                                return Diagnostic.Kind.ERROR;
                            }
                            if ((severity & 0x20) != 0) {
                                return Diagnostic.Kind.WARNING;
                            }
                            if (false) {
                                return Diagnostic.Kind.MANDATORY_WARNING;
                            }
                            return Diagnostic.Kind.OTHER;
                        }

                        @Override
                        public long getLineNumber() {
                            return lineNumber;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            this.setLocale(locale);
                            return this.getLocalizedMessage(problemId, problemArguments);
                        }

                        @Override
                        public long getPosition() {
                            return startPosition;
                        }

                        @Override
                        public JavaFileObject getSource() {
                            try {
                                if ((this).EclipseCompilerImpl.this.fileManager.hasLocation(StandardLocation.SOURCE_PATH)) {
                                    return (this).EclipseCompilerImpl.this.fileManager.getJavaFileForInput(StandardLocation.SOURCE_PATH, new String(originatingFileName), JavaFileObject.Kind.SOURCE);
                                }
                            }
                            catch (IOException iOException) {}
                            return null;
                        }

                        @Override
                        public long getStartPosition() {
                            return startPosition;
                        }
                    });
                }
                return super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
        };
    }

    @Override
    protected void initialize(PrintWriter outWriter, PrintWriter errWriter, boolean systemExit, Map customDefaultOptions, CompilationProgress compilationProgress) {
        super.initialize(outWriter, errWriter, systemExit, customDefaultOptions, compilationProgress);
        this.javaFileObjectMap = new HashMap();
    }

    @Override
    protected void initializeAnnotationProcessorManager() {
        super.initializeAnnotationProcessorManager();
        if (this.batchCompiler.annotationProcessorManager != null && this.processors != null) {
            this.batchCompiler.annotationProcessorManager.setProcessors(this.processors);
        } else if (this.processors != null) {
            throw new UnsupportedOperationException("Cannot handle annotation processing");
        }
    }

    @Override
    public void outputClassFiles(CompilationResult unitResult) {
        if (unitResult != null && (!unitResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFiles = unitResult.getClassFiles();
            boolean generateClasspathStructure = this.fileManager.hasLocation(StandardLocation.CLASS_OUTPUT);
            String currentDestinationPath = this.destinationPath;
            File outputLocation = null;
            if (currentDestinationPath != null) {
                outputLocation = new File(currentDestinationPath);
                outputLocation.mkdirs();
            }
            int i = 0;
            int fileCount = classFiles.length;
            while (i < fileCount) {
                ClassFile classFile = classFiles[i];
                char[] filename = classFile.fileName();
                int length = filename.length;
                char[] relativeName = new char[length + 6];
                System.arraycopy(filename, 0, relativeName, 0, length);
                System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                CharOperation.replace(relativeName, '/', File.separatorChar);
                String relativeStringName = new String(relativeName);
                if (this.compilerOptions.verbose) {
                    this.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), relativeStringName}));
                }
                try {
                    JavaFileObject javaFileForOutput = this.fileManager.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, new String(filename), JavaFileObject.Kind.CLASS, this.javaFileObjectMap.get(unitResult.compilationUnit));
                    if (generateClasspathStructure) {
                        if (currentDestinationPath != null) {
                            int index = CharOperation.lastIndexOf(File.separatorChar, relativeName);
                            if (index != -1) {
                                File currentFolder = new File(currentDestinationPath, relativeStringName.substring(0, index));
                                currentFolder.mkdirs();
                            }
                        } else {
                            String path = javaFileForOutput.toUri().getPath();
                            int index = path.lastIndexOf(47);
                            if (index != -1) {
                                File file = new File(path.substring(0, index));
                                file.mkdirs();
                            }
                        }
                    }
                    OutputStream openOutputStream = javaFileForOutput.openOutputStream();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(openOutputStream);
                    bufferedOutputStream.write(classFile.header, 0, classFile.headerOffset);
                    bufferedOutputStream.write(classFile.contents, 0, classFile.contentsOffset);
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (IOException e2) {
                    this.logger.logNoClassFileCreated(currentDestinationPath, relativeStringName, e2);
                }
                this.logger.logClassFile(generateClasspathStructure, currentDestinationPath, relativeStringName);
                ++this.exportedClassFilesCounter;
                ++i;
            }
            this.batchCompiler.lookupEnvironment.releaseClassFiles(classFiles);
        }
    }

    @Override
    protected void setPaths(ArrayList bootclasspaths, String sourcepathClasspathArg, ArrayList sourcepathClasspaths, ArrayList classpaths, ArrayList extdirsClasspaths, ArrayList endorsedDirClasspaths, String customEncoding) {
        int n;
        FileSystem.Classpath classpath2;
        ArrayList fileSystemClasspaths = new ArrayList();
        EclipseFileManager javaFileManager = null;
        StandardJavaFileManager standardJavaFileManager = null;
        if (this.fileManager instanceof EclipseFileManager) {
            javaFileManager = (EclipseFileManager)this.fileManager;
        }
        if (this.fileManager instanceof StandardJavaFileManager) {
            standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
        }
        if (javaFileManager != null && (javaFileManager.flags & 4) == 0 && (javaFileManager.flags & 2) != 0) {
            fileSystemClasspaths.addAll(this.handleEndorseddirs(null));
        }
        Iterable<? extends File> location = null;
        if (standardJavaFileManager != null) {
            location = standardJavaFileManager.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
        }
        if (location != null) {
            for (File file : location) {
                FileSystem.Classpath classpath2 = FileSystem.getClasspath(file.getAbsolutePath(), null, null);
                if (classpath2 == null) continue;
                fileSystemClasspaths.add(classpath2);
            }
        }
        if (javaFileManager != null && (javaFileManager.flags & 1) == 0 && (javaFileManager.flags & 2) != 0) {
            fileSystemClasspaths.addAll(this.handleExtdirs(null));
        }
        if ((location = standardJavaFileManager != null ? standardJavaFileManager.getLocation(StandardLocation.SOURCE_PATH) : null) != null) {
            for (File file : location) {
                classpath2 = FileSystem.getClasspath(file.getAbsolutePath(), null, null);
                if (classpath2 == null) continue;
                fileSystemClasspaths.add(classpath2);
            }
        }
        if ((location = standardJavaFileManager != null ? standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH) : null) != null) {
            for (File file : location) {
                classpath2 = FileSystem.getClasspath(file.getAbsolutePath(), null, null);
                if (classpath2 == null) continue;
                fileSystemClasspaths.add(classpath2);
            }
        }
        if (this.checkedClasspaths == null) {
            fileSystemClasspaths.addAll(this.handleBootclasspath(null, null));
            fileSystemClasspaths.addAll(this.handleClasspath(null, null));
        }
        if ((n = (fileSystemClasspaths = FileSystem.ClasspathNormalizer.normalize(fileSystemClasspaths)).size()) != 0) {
            this.checkedClasspaths = new FileSystem.Classpath[n];
            int i = 0;
            for (FileSystem.Classpath classpath2 : fileSystemClasspaths) {
                this.checkedClasspaths[i++] = classpath2;
            }
        }
    }
}

