/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.util.TimeoutObserver;

public class Watchdog
implements Runnable {
    private Vector observers = new Vector(1);
    private long timeout = -1L;
    private boolean stopped = false;

    public Watchdog(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout less than 1.");
        }
        this.timeout = timeout;
    }

    public void addTimeoutObserver(TimeoutObserver to) {
        this.observers.addElement(to);
    }

    public void removeTimeoutObserver(TimeoutObserver to) {
        this.observers.removeElement(to);
    }

    protected final void fireTimeoutOccured() {
        Enumeration e2 = this.observers.elements();
        while (e2.hasMoreElements()) {
            ((TimeoutObserver)e2.nextElement()).timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void run() {
        long now2;
        long until = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && until > (now2 = System.currentTimeMillis())) {
            try {
                void var3_2;
                this.wait(until - var3_2);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
        }
        if (!this.stopped) {
            this.fireTimeoutOccured();
        }
    }
}

