/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.tools.ant.BuildException;

public class ScriptRunner {
    private String language;
    private String script = "";
    private Map beans = new HashMap();

    public void addBeans(Map dictionary) {
        Iterator i = dictionary.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            try {
                Object val = dictionary.get(key);
                this.addBean(key, val);
            }
            catch (BuildException ex) {
                // empty catch block
            }
        }
    }

    public void addBean(String key, Object bean) {
        boolean isValid = key.length() > 0 && Character.isJavaIdentifierStart(key.charAt(0));
        int i = 1;
        while (isValid && i < key.length()) {
            isValid = Character.isJavaIdentifierPart(key.charAt(i));
            ++i;
        }
        if (isValid) {
            this.beans.put(key, bean);
        }
    }

    public void executeScript(String execName) throws BuildException {
        if (this.language == null) {
            throw new BuildException("script language must be specified");
        }
        try {
            BSFManager manager = new BSFManager();
            Iterator i = this.beans.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object value = this.beans.get(key);
                if (value != null) {
                    manager.declareBean(key, value, value.getClass());
                    continue;
                }
                manager.undeclareBean(key);
            }
            manager.exec(this.language, execName, 0, 0, (Object)this.script);
        }
        catch (BSFException be) {
            Throwable t = be;
            Throwable te = be.getTargetException();
            if (te != null) {
                if (te instanceof BuildException) {
                    throw (BuildException)te;
                }
                t = te;
            }
            throw new BuildException(t);
        }
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSrc(File file) {
        if (!file.exists()) {
            throw new BuildException("file " + file.getPath() + " not found.");
        }
        int count = (int)file.length();
        byte[] data = new byte[count];
        try {
            FileInputStream inStream = new FileInputStream(file);
            inStream.read(data);
            inStream.close();
        }
        catch (IOException e2) {
            throw new BuildException(e2);
        }
        this.script = this.script + new String(data);
    }

    public void addText(String text) {
        this.script = this.script + text;
    }

    static {
        BSFManager.registerScriptingEngine((String)"groovy", (String)"org.codehaus.groovy.bsf.GroovyEngine", (String[])new String[]{"groovy", "gy"});
    }
}

