/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class ResourceUtils {
    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets) {
        return ResourceUtils.selectOutOfDateSources(logTo, source, mapper, targets, FileUtils.newFileUtils().getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets, long granularity) {
        long now2 = new Date().getTime() + granularity;
        Vector<Resource> vresult = new Vector<Resource>();
        int counter = 0;
        while (counter < source.length) {
            String[] targetnames;
            if (source[counter].getLastModified() > now2) {
                logTo.log("Warning: " + source[counter].getName() + " modified in the future.", 1);
            }
            if ((targetnames = mapper.mapFileName(source[counter].getName().replace('/', File.separatorChar))) != null) {
                boolean added = false;
                StringBuffer targetList = new StringBuffer();
                int ctarget = 0;
                while (!added && ctarget < targetnames.length) {
                    Resource atarget = targets.getResource(targetnames[ctarget].replace(File.separatorChar, '/'));
                    if (!atarget.isExists()) {
                        logTo.log(source[counter].getName() + " added as " + atarget.getName() + " doesn't exist.", 3);
                        vresult.addElement(source[counter]);
                        added = true;
                    } else if (!atarget.isDirectory() && SelectorUtils.isOutOfDate(source[counter], atarget, (int)granularity)) {
                        logTo.log(source[counter].getName() + " added as " + atarget.getName() + " is outdated.", 3);
                        vresult.addElement(source[counter]);
                        added = true;
                    } else {
                        if (targetList.length() > 0) {
                            targetList.append(", ");
                        }
                        targetList.append(atarget.getName());
                    }
                    ++ctarget;
                }
                if (!added) {
                    logTo.log(source[counter].getName() + " omitted as " + targetList.toString() + (targetnames.length == 1 ? " is" : " are ") + " up to date.", 3);
                }
            } else {
                logTo.log(source[counter].getName() + " skipped - don't know how to handle it", 3);
            }
            ++counter;
        }
        Object[] result = new Resource[vresult.size()];
        vresult.copyInto(result);
        return result;
    }
}

