/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class PropertySet
extends DataType {
    private boolean dynamic = true;
    private boolean negate = false;
    private Set cachedNames;
    private Vector ptyRefs = new Vector();
    private Vector setRefs = new Vector();
    private Mapper mapper;
    private boolean noAttributeSet = true;
    static /* synthetic */ Class class$org$apache$tools$ant$types$PropertySet;

    public void appendName(String name) {
        PropertyRef r = new PropertyRef();
        r.setName(name);
        this.addPropertyref(r);
    }

    public void appendRegex(String regex) {
        PropertyRef r = new PropertyRef();
        r.setRegex(regex);
        this.addPropertyref(r);
    }

    public void appendPrefix(String prefix) {
        PropertyRef r = new PropertyRef();
        r.setPrefix(prefix);
        this.addPropertyref(r);
    }

    public void appendBuiltin(BuiltinPropertySetName b) {
        PropertyRef r = new PropertyRef();
        r.setBuiltin(b);
        this.addPropertyref(r);
    }

    public void setMapper(String type, String from, String to) {
        Mapper m = this.createMapper();
        Mapper.MapperType mapperType = new Mapper.MapperType();
        mapperType.setValue(type);
        m.setFrom(from);
        m.setTo(to);
    }

    public void addPropertyref(PropertyRef ref) {
        this.assertNotReference();
        this.ptyRefs.addElement(ref);
    }

    public void addPropertyset(PropertySet ref) {
        this.assertNotReference();
        this.setRefs.addElement(ref);
    }

    public Mapper createMapper() {
        this.assertNotReference();
        if (this.mapper != null) {
            throw new BuildException("Too many <mapper>s!");
        }
        this.mapper = new Mapper(this.getProject());
        return this.mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setDynamic(boolean dynamic) {
        this.assertNotReference();
        this.dynamic = dynamic;
    }

    public void setNegate(boolean negate) {
        this.assertNotReference();
        this.negate = negate;
    }

    public boolean getDynamic() {
        return this.isReference() ? this.getRef().dynamic : this.dynamic;
    }

    public Mapper getMapper() {
        return this.isReference() ? this.getRef().mapper : this.mapper;
    }

    private Hashtable getAllSystemProperties() {
        Hashtable<String, String> ret = new Hashtable<String, String>();
        Enumeration<?> e2 = System.getProperties().propertyNames();
        while (e2.hasMoreElements()) {
            String name = (String)e2.nextElement();
            ret.put(name, System.getProperties().getProperty(name));
        }
        return ret;
    }

    public Properties getProperties() {
        if (this.isReference()) {
            return this.getRef().getProperties();
        }
        Set<Object> names = null;
        Project prj = this.getProject();
        Hashtable props = prj == null ? this.getAllSystemProperties() : prj.getProperties();
        Enumeration e2 = this.setRefs.elements();
        while (e2.hasMoreElements()) {
            PropertySet set = (PropertySet)e2.nextElement();
            props.putAll(set.getProperties());
        }
        if (this.getDynamic() || this.cachedNames == null) {
            names = new HashSet();
            this.addPropertyNames(names, props);
            Enumeration e3 = this.setRefs.elements();
            while (e3.hasMoreElements()) {
                PropertySet set = (PropertySet)e3.nextElement();
                names.addAll(set.getProperties().keySet());
            }
            if (this.negate) {
                HashSet complement = new HashSet(props.keySet());
                complement.removeAll(names);
                names = complement;
            }
            if (!this.getDynamic()) {
                this.cachedNames = names;
            }
        } else {
            names = this.cachedNames;
        }
        FileNameMapper m = null;
        Mapper myMapper = this.getMapper();
        if (myMapper != null) {
            m = myMapper.getImplementation();
        }
        Properties properties = new Properties();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String[] newname;
            String name = (String)iter.next();
            String value = (String)props.get(name);
            if (m != null && (newname = m.mapFileName(name)) != null) {
                name = newname[0];
            }
            properties.setProperty(name, value);
        }
        return properties;
    }

    private void addPropertyNames(Set names, Hashtable properties) {
        Project prj = this.getProject();
        Enumeration e2 = this.ptyRefs.elements();
        while (e2.hasMoreElements()) {
            PropertyRef r = (PropertyRef)e2.nextElement();
            if (r.name != null) {
                if (prj == null || prj.getProperty(r.name) == null) continue;
                names.add(r.name);
                continue;
            }
            if (r.prefix != null) {
                Enumeration p = properties.keys();
                while (p.hasMoreElements()) {
                    String name = (String)p.nextElement();
                    if (!name.startsWith(r.prefix)) continue;
                    names.add(name);
                }
                continue;
            }
            if (r.regex != null) {
                RegexpMatcherFactory matchMaker = new RegexpMatcherFactory();
                RegexpMatcher matcher = matchMaker.newRegexpMatcher();
                matcher.setPattern(r.regex);
                Enumeration p = properties.keys();
                while (p.hasMoreElements()) {
                    String name = (String)p.nextElement();
                    if (!matcher.matches(name)) continue;
                    names.add(name);
                }
                continue;
            }
            if (r.builtin != null) {
                if (r.builtin.equals("all")) {
                    names.addAll(properties.keySet());
                    continue;
                }
                if (r.builtin.equals("system")) {
                    names.addAll(System.getProperties().keySet());
                    continue;
                }
                if (r.builtin.equals("commandline")) {
                    names.addAll(this.getProject().getUserProperties().keySet());
                    continue;
                }
                throw new BuildException("Impossible: Invalid builtin attribute!");
            }
            throw new BuildException("Impossible: Invalid PropertyRef!");
        }
    }

    protected PropertySet getRef() {
        return (PropertySet)this.getCheckedRef(class$org$apache$tools$ant$types$PropertySet == null ? (class$org$apache$tools$ant$types$PropertySet = PropertySet.class$("org.apache.tools.ant.types.PropertySet")) : class$org$apache$tools$ant$types$PropertySet, "propertyset");
    }

    public final void setRefid(Reference r) {
        if (!this.noAttributeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected final void assertNotReference() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.noAttributeSet = false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(this.getProperties());
        Iterator<Map.Entry<Object, Object>> i = sorted.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> e2 = i.next();
            if (b.length() != 0) {
                b.append(", ");
            }
            b.append(e2.getKey().toString());
            b.append("=");
            b.append(e2.getValue().toString());
        }
        return b.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BuiltinPropertySetName
    extends EnumeratedAttribute {
        static final String ALL = "all";
        static final String SYSTEM = "system";
        static final String COMMANDLINE = "commandline";

        public String[] getValues() {
            return new String[]{ALL, SYSTEM, COMMANDLINE};
        }
    }

    public static class PropertyRef {
        private int count;
        private String name;
        private String regex;
        private String prefix;
        private String builtin;

        public void setName(String name) {
            this.assertValid("name", name);
            this.name = name;
        }

        public void setRegex(String regex) {
            this.assertValid("regex", regex);
            this.regex = regex;
        }

        public void setPrefix(String prefix) {
            this.assertValid("prefix", prefix);
            this.prefix = prefix;
        }

        public void setBuiltin(BuiltinPropertySetName b) {
            String pBuiltIn = b.getValue();
            this.assertValid("builtin", pBuiltIn);
            this.builtin = pBuiltIn;
        }

        private void assertValid(String attr, String value) {
            if (value == null || value.length() < 1) {
                throw new BuildException("Invalid attribute: " + attr);
            }
            if (++this.count != 1) {
                throw new BuildException("Attributes name, regex, and prefix are mutually exclusive");
            }
        }

        public String toString() {
            return "name=" + this.name + ", regex=" + this.regex + ", prefix=" + this.prefix + ", builtin=" + this.builtin;
        }
    }
}

