/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CvsTagEntry;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DOMUtils;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CvsTagDiff
extends AbstractCvsTask {
    private static final DOMElementWriter DOM_WRITER = new DOMElementWriter();
    static final String FILE_STRING = "File ";
    static final String TO_STRING = " to ";
    static final String FILE_IS_NEW = " is new;";
    static final String REVISION = "revision ";
    static final String FILE_HAS_CHANGED = " changed from revision ";
    static final String FILE_WAS_REMOVED = " is removed";
    private String mypackage;
    private String mystartTag;
    private String myendTag;
    private String mystartDate;
    private String myendDate;
    private File mydestfile;
    private FileUtils myfileUtils = FileUtils.newFileUtils();

    public void setPackage(String p) {
        this.mypackage = p;
    }

    public void setStartTag(String s) {
        this.mystartTag = s;
    }

    public void setStartDate(String s) {
        this.mystartDate = s;
    }

    public void setEndTag(String s) {
        this.myendTag = s;
    }

    public void setEndDate(String s) {
        this.myendDate = s;
    }

    public void setDestFile(File f) {
        this.mydestfile = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        block8: {
            this.validate();
            this.addCommandArgument("rdiff");
            this.addCommandArgument("-s");
            if (this.mystartTag != null) {
                this.addCommandArgument("-r");
                this.addCommandArgument(this.mystartTag);
            } else {
                this.addCommandArgument("-D");
                this.addCommandArgument(this.mystartDate);
            }
            if (this.myendTag != null) {
                this.addCommandArgument("-r");
                this.addCommandArgument(this.myendTag);
            } else {
                this.addCommandArgument("-D");
                this.addCommandArgument(this.myendDate);
            }
            StringTokenizer myTokenizer = new StringTokenizer(this.mypackage);
            while (myTokenizer.hasMoreTokens()) {
                this.addCommandArgument(myTokenizer.nextToken());
            }
            this.setCommand("");
            File tmpFile = null;
            try {
                tmpFile = this.myfileUtils.createTempFile("cvstagdiff", ".log", null);
                tmpFile.deleteOnExit();
                this.setOutput(tmpFile);
                super.execute();
                CvsTagEntry[] entries = this.parseRDiff(tmpFile);
                this.writeTagDiff(entries);
                Object var5_4 = null;
                if (tmpFile == null) break block8;
                tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CvsTagEntry[] parseRDiff(File tmpFile) throws BuildException {
        Object[] objectArray;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(tmpFile));
            String toBeRemoved = FILE_STRING + this.mypackage + "/";
            int headerLength = toBeRemoved.length();
            Vector<CvsTagEntry> entries = new Vector<CvsTagEntry>();
            String line = reader.readLine();
            CvsTagEntry entry = null;
            while (true) {
                if (null == line) {
                    Object[] array = new CvsTagEntry[entries.size()];
                    entries.copyInto(array);
                    objectArray = array;
                    if (reader == null) return objectArray;
                    break;
                }
                if (line.length() > headerLength) {
                    String filename;
                    int index = (line = line.startsWith(toBeRemoved) ? line.substring(headerLength) : line.substring(FILE_STRING.length())).indexOf(FILE_IS_NEW);
                    if (index != -1) {
                        filename = line.substring(0, index);
                        String rev = null;
                        int indexrev = -1;
                        indexrev = line.indexOf(REVISION, index);
                        if (indexrev != -1) {
                            rev = line.substring(indexrev + REVISION.length());
                        }
                        entry = new CvsTagEntry(filename, rev);
                        entries.addElement(entry);
                        this.log(entry.toString(), 3);
                    } else {
                        index = line.indexOf(FILE_HAS_CHANGED);
                        if (index != -1) {
                            filename = line.substring(0, index);
                            int revSeparator = line.indexOf(TO_STRING, index);
                            String prevRevision = line.substring(index + FILE_HAS_CHANGED.length(), revSeparator);
                            String revision = line.substring(revSeparator + TO_STRING.length());
                            entry = new CvsTagEntry(filename, revision, prevRevision);
                            entries.addElement(entry);
                            this.log(entry.toString(), 3);
                        } else {
                            index = line.indexOf(FILE_WAS_REMOVED);
                            if (index != -1) {
                                filename = line.substring(0, index);
                                String rev = null;
                                int indexrev = -1;
                                indexrev = line.indexOf(REVISION, index);
                                if (indexrev != -1) {
                                    rev = line.substring(indexrev + REVISION.length());
                                }
                                entry = new CvsTagEntry(filename, null, rev);
                                entries.addElement(entry);
                                this.log(entry.toString(), 3);
                            }
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e3) {
            try {
                throw new BuildException("Error in parsing", e3);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e4) {
                    this.log(e4.toString(), 0);
                    throw throwable;
                }
            }
        }
        try {
            reader.close();
            return objectArray;
        }
        catch (IOException e2) {
            this.log(e2.toString(), 0);
        }
        return objectArray;
    }

    private void writeTagDiff(CvsTagEntry[] entries) throws BuildException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.mydestfile);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            Document doc = DOMUtils.newDocument();
            Element root = doc.createElement("tagdiff");
            if (this.mystartTag != null) {
                root.setAttribute("startTag", this.mystartTag);
            } else {
                root.setAttribute("startDate", this.mystartDate);
            }
            if (this.myendTag != null) {
                root.setAttribute("endTag", this.myendTag);
            } else {
                root.setAttribute("endDate", this.myendDate);
            }
            root.setAttribute("cvsroot", this.getCvsRoot());
            root.setAttribute("package", this.mypackage);
            DOM_WRITER.openElement(root, writer, 0, "\t");
            writer.println();
            int i = 0;
            int c = entries.length;
            while (i < c) {
                this.writeTagEntry(doc, writer, entries[i]);
                ++i;
            }
            DOM_WRITER.closeElement(root, writer, 0, "\t", true);
            writer.flush();
            writer.close();
        }
        catch (UnsupportedEncodingException uee) {
            this.log(uee.toString(), 0);
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.toString(), ioe);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException ioe) {
                    this.log(ioe.toString(), 0);
                }
            }
        }
    }

    private void writeTagEntry(Document doc, PrintWriter writer, CvsTagEntry entry) throws IOException {
        Element ent = doc.createElement("entry");
        Element f = DOMUtils.createChildElement(ent, "file");
        DOMUtils.appendCDATAElement(f, "name", entry.getFile());
        if (entry.getRevision() != null) {
            DOMUtils.appendTextElement(f, "revision", entry.getRevision());
        }
        if (entry.getPreviousRevision() != null) {
            DOMUtils.appendTextElement(f, "prevrevision", entry.getPreviousRevision());
        }
        DOM_WRITER.write(ent, writer, 1, "\t");
    }

    private void validate() throws BuildException {
        if (null == this.mypackage) {
            throw new BuildException("Package/module must be set.");
        }
        if (null == this.mydestfile) {
            throw new BuildException("Destfile must be set.");
        }
        if (null == this.mystartTag && null == this.mystartDate) {
            throw new BuildException("Start tag or start date must be set.");
        }
        if (null != this.mystartTag && null != this.mystartDate) {
            throw new BuildException("Only one of start tag and start date must be set.");
        }
        if (null == this.myendTag && null == this.myendDate) {
            throw new BuildException("End tag or end date must be set.");
        }
        if (null != this.myendTag && null != this.myendDate) {
            throw new BuildException("Only one of end tag and end date must be set.");
        }
    }
}

