/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.util.CollectionUtils;

public class Manifest {
    public static final String ATTRIBUTE_MANIFEST_VERSION = "Manifest-Version";
    public static final String ATTRIBUTE_SIGNATURE_VERSION = "Signature-Version";
    public static final String ATTRIBUTE_NAME = "Name";
    public static final String ATTRIBUTE_FROM = "From";
    public static final String ATTRIBUTE_CLASSPATH = "Class-Path";
    public static final String DEFAULT_MANIFEST_VERSION = "1.0";
    public static final int MAX_LINE_LENGTH = 72;
    public static final int MAX_SECTION_LENGTH = 70;
    public static final String EOL = "\r\n";
    private String manifestVersion = "1.0";
    private Section mainSection = new Section();
    private Hashtable sections = new Hashtable();
    private Vector sectionIndex = new Vector();
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Manifest;

    public static Manifest getDefaultManifest() throws BuildException {
        try {
            String defManifest = "/org/apache/tools/ant/defaultManifest.mf";
            InputStream in = (class$org$apache$tools$ant$taskdefs$Manifest == null ? (class$org$apache$tools$ant$taskdefs$Manifest = Manifest.class$("org.apache.tools.ant.taskdefs.Manifest")) : class$org$apache$tools$ant$taskdefs$Manifest).getResourceAsStream(defManifest);
            if (in == null) {
                throw new BuildException("Could not find default manifest: " + defManifest);
            }
            try {
                Manifest defaultManifest = new Manifest(new InputStreamReader(in, "UTF-8"));
                Attribute createdBy = new Attribute("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
                defaultManifest.getMainSection().storeAttribute(createdBy);
                return defaultManifest;
            }
            catch (UnsupportedEncodingException e2) {
                return new Manifest(new InputStreamReader(in));
            }
        }
        catch (ManifestException e3) {
            throw new BuildException("Default manifest is invalid !!", e3);
        }
        catch (IOException e4) {
            throw new BuildException("Unable to read default manifest", e4);
        }
    }

    public Manifest() {
        this.manifestVersion = null;
    }

    public Manifest(Reader r) throws ManifestException, IOException {
        BufferedReader reader = new BufferedReader(r);
        String nextSectionName = this.mainSection.read(reader);
        String readManifestVersion = this.mainSection.getAttributeValue(ATTRIBUTE_MANIFEST_VERSION);
        if (readManifestVersion != null) {
            this.manifestVersion = readManifestVersion;
            this.mainSection.removeAttribute(ATTRIBUTE_MANIFEST_VERSION);
        }
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            Section section = new Section();
            if (nextSectionName == null) {
                Attribute sectionName = new Attribute(line);
                if (!sectionName.getName().equalsIgnoreCase(ATTRIBUTE_NAME)) {
                    throw new ManifestException("Manifest sections should start with a \"Name\" attribute and not \"" + sectionName.getName() + "\"");
                }
                nextSectionName = sectionName.getValue();
            } else {
                Attribute firstAttribute = new Attribute(line);
                section.addAttributeAndCheck(firstAttribute);
            }
            section.setName(nextSectionName);
            nextSectionName = section.read(reader);
            this.addConfiguredSection(section);
        }
    }

    public void addConfiguredSection(Section section) throws ManifestException {
        String sectionName = section.getName();
        if (sectionName == null) {
            throw new BuildException("Sections must have a name");
        }
        this.sections.put(sectionName, section);
        if (!this.sectionIndex.contains(sectionName)) {
            this.sectionIndex.addElement(sectionName);
        }
    }

    public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
        if (attribute.getKey() == null || attribute.getValue() == null) {
            throw new BuildException("Attributes must have name and value");
        }
        if (attribute.getKey().equalsIgnoreCase(ATTRIBUTE_MANIFEST_VERSION)) {
            this.manifestVersion = attribute.getValue();
        } else {
            this.mainSection.addConfiguredAttribute(attribute);
        }
    }

    public void merge(Manifest other) throws ManifestException {
        this.merge(other, false);
    }

    public void merge(Manifest other, boolean overwriteMain) throws ManifestException {
        if (other != null) {
            if (overwriteMain) {
                this.mainSection = (Section)other.mainSection.clone();
            } else {
                this.mainSection.merge(other.mainSection);
            }
            if (other.manifestVersion != null) {
                this.manifestVersion = other.manifestVersion;
            }
            Enumeration e2 = other.getSectionNames();
            while (e2.hasMoreElements()) {
                String sectionName = (String)e2.nextElement();
                Section ourSection = (Section)this.sections.get(sectionName);
                Section otherSection = (Section)other.sections.get(sectionName);
                if (ourSection == null) {
                    if (otherSection == null) continue;
                    this.addConfiguredSection((Section)otherSection.clone());
                    continue;
                }
                ourSection.merge(otherSection);
            }
        }
    }

    public void write(PrintWriter writer) throws IOException {
        writer.print("Manifest-Version: " + this.manifestVersion + EOL);
        String signatureVersion = this.mainSection.getAttributeValue(ATTRIBUTE_SIGNATURE_VERSION);
        if (signatureVersion != null) {
            writer.print("Signature-Version: " + signatureVersion + EOL);
            this.mainSection.removeAttribute(ATTRIBUTE_SIGNATURE_VERSION);
        }
        this.mainSection.write(writer);
        if (signatureVersion != null) {
            try {
                Attribute svAttr = new Attribute(ATTRIBUTE_SIGNATURE_VERSION, signatureVersion);
                this.mainSection.addConfiguredAttribute(svAttr);
            }
            catch (ManifestException e2) {
                // empty catch block
            }
        }
        Enumeration e3 = this.sectionIndex.elements();
        while (e3.hasMoreElements()) {
            String sectionName = (String)e3.nextElement();
            Section section = this.getSection(sectionName);
            section.write(writer);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.write(new PrintWriter(sw));
        }
        catch (IOException e2) {
            return null;
        }
        return sw.toString();
    }

    public Enumeration getWarnings() {
        Vector warnings = new Vector();
        Enumeration warnEnum = this.mainSection.getWarnings();
        while (warnEnum.hasMoreElements()) {
            warnings.addElement(warnEnum.nextElement());
        }
        Enumeration e2 = this.sections.elements();
        while (e2.hasMoreElements()) {
            Section section = (Section)e2.nextElement();
            Enumeration e22 = section.getWarnings();
            while (e22.hasMoreElements()) {
                warnings.addElement(e22.nextElement());
            }
        }
        return warnings.elements();
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.manifestVersion != null) {
            hashCode += this.manifestVersion.hashCode();
        }
        hashCode += this.mainSection.hashCode();
        return hashCode += this.sections.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == null || rhs.getClass() != this.getClass()) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        Manifest rhsManifest = (Manifest)rhs;
        if (this.manifestVersion == null ? rhsManifest.manifestVersion != null : !this.manifestVersion.equals(rhsManifest.manifestVersion)) {
            return false;
        }
        if (!this.mainSection.equals(rhsManifest.mainSection)) {
            return false;
        }
        return CollectionUtils.equals(this.sections, rhsManifest.sections);
    }

    public String getManifestVersion() {
        return this.manifestVersion;
    }

    public Section getMainSection() {
        return this.mainSection;
    }

    public Section getSection(String name) {
        return (Section)this.sections.get(name);
    }

    public Enumeration getSectionNames() {
        return this.sectionIndex.elements();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Section {
        private Vector warnings = new Vector();
        private String name = null;
        private Hashtable attributes = new Hashtable();
        private Vector attributeIndex = new Vector();

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String read(BufferedReader reader) throws ManifestException, IOException {
            String nameReadAhead;
            Attribute attribute = null;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null || line.length() == 0) {
                    return null;
                }
                if (line.charAt(0) == ' ') {
                    if (attribute == null) {
                        if (this.name != null) {
                            this.name = this.name + line.substring(1);
                            continue;
                        }
                        throw new ManifestException("Can't start an attribute with a continuation line " + line);
                    }
                    attribute.addContinuation(line);
                    continue;
                }
                attribute = new Attribute(line);
                nameReadAhead = this.addAttributeAndCheck(attribute);
                attribute = this.getAttribute(attribute.getKey());
                if (nameReadAhead != null) break;
            }
            return nameReadAhead;
        }

        public void merge(Section section) throws ManifestException {
            if (this.name == null && section.getName() != null || this.name != null && !this.name.equalsIgnoreCase(section.getName())) {
                throw new ManifestException("Unable to merge sections with different names");
            }
            Enumeration e2 = section.getAttributeKeys();
            Attribute classpathAttribute = null;
            while (e2.hasMoreElements()) {
                String attributeName = (String)e2.nextElement();
                Attribute attribute = section.getAttribute(attributeName);
                if (attributeName.equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    if (classpathAttribute == null) {
                        classpathAttribute = new Attribute();
                        classpathAttribute.setName(Manifest.ATTRIBUTE_CLASSPATH);
                    }
                    Enumeration cpe = attribute.getValues();
                    while (cpe.hasMoreElements()) {
                        String value = (String)cpe.nextElement();
                        classpathAttribute.addValue(value);
                    }
                    continue;
                }
                this.storeAttribute(attribute);
            }
            if (classpathAttribute != null) {
                this.storeAttribute(classpathAttribute);
            }
            Enumeration warnEnum = section.warnings.elements();
            while (warnEnum.hasMoreElements()) {
                this.warnings.addElement(warnEnum.nextElement());
            }
        }

        public void write(PrintWriter writer) throws IOException {
            if (this.name != null) {
                Attribute nameAttr = new Attribute(Manifest.ATTRIBUTE_NAME, this.name);
                nameAttr.write(writer);
            }
            Enumeration e2 = this.getAttributeKeys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                Attribute attribute = this.getAttribute(key);
                attribute.write(writer);
            }
            writer.print(Manifest.EOL);
        }

        public Attribute getAttribute(String attributeName) {
            return (Attribute)this.attributes.get(attributeName.toLowerCase());
        }

        public Enumeration getAttributeKeys() {
            return this.attributeIndex.elements();
        }

        public String getAttributeValue(String attributeName) {
            Attribute attribute = this.getAttribute(attributeName.toLowerCase());
            if (attribute == null) {
                return null;
            }
            return attribute.getValue();
        }

        public void removeAttribute(String attributeName) {
            String key = attributeName.toLowerCase();
            this.attributes.remove(key);
            this.attributeIndex.removeElement(key);
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            String check = this.addAttributeAndCheck(attribute);
            if (check != null) {
                throw new BuildException("Specify the section name using the \"name\" attribute of the <section> element rather than using a \"Name\" manifest attribute");
            }
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            if (attribute.getName() == null || attribute.getValue() == null) {
                throw new BuildException("Attributes must have name and value");
            }
            if (attribute.getKey().equalsIgnoreCase(Manifest.ATTRIBUTE_NAME)) {
                this.warnings.addElement("\"Name\" attributes should not occur in the main section and must be the first element in all other sections: \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
                return attribute.getValue();
            }
            if (attribute.getKey().startsWith(Manifest.ATTRIBUTE_FROM.toLowerCase())) {
                this.warnings.addElement("Manifest attributes should not start with \"From\" in \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
            } else {
                String attributeKey = attribute.getKey();
                if (attributeKey.equalsIgnoreCase(Manifest.ATTRIBUTE_CLASSPATH)) {
                    Attribute classpathAttribute = (Attribute)this.attributes.get(attributeKey);
                    if (classpathAttribute == null) {
                        this.storeAttribute(attribute);
                    } else {
                        this.warnings.addElement("Multiple Class-Path attributes are supported but violate the Jar specification and may not be correctly processed in all environments");
                        Enumeration e2 = attribute.getValues();
                        while (e2.hasMoreElements()) {
                            String value = (String)e2.nextElement();
                            classpathAttribute.addValue(value);
                        }
                    }
                } else {
                    if (this.attributes.containsKey(attributeKey)) {
                        throw new ManifestException("The attribute \"" + attribute.getName() + "\" may not occur more " + "than once in the same section");
                    }
                    this.storeAttribute(attribute);
                }
            }
            return null;
        }

        public Object clone() {
            Section cloned = new Section();
            cloned.setName(this.name);
            Enumeration e2 = this.getAttributeKeys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                Attribute attribute = this.getAttribute(key);
                cloned.storeAttribute(new Attribute(attribute.getName(), attribute.getValue()));
            }
            return cloned;
        }

        private void storeAttribute(Attribute attribute) {
            if (attribute == null) {
                return;
            }
            String attributeKey = attribute.getKey();
            this.attributes.put(attributeKey, attribute);
            if (!this.attributeIndex.contains(attributeKey)) {
                this.attributeIndex.addElement(attributeKey);
            }
        }

        public Enumeration getWarnings() {
            return this.warnings.elements();
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.name != null) {
                hashCode += this.name.hashCode();
            }
            return hashCode += this.attributes.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Section rhsSection = (Section)rhs;
            return CollectionUtils.equals(this.attributes, rhsSection.attributes);
        }
    }

    public static class Attribute {
        private String name = null;
        private Vector values = new Vector();
        private int currentIndex = 0;

        public Attribute() {
        }

        public Attribute(String line) throws ManifestException {
            this.parse(line);
        }

        public Attribute(String name, String value) {
            this.name = name;
            this.setValue(value);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.name != null) {
                hashCode += this.name.hashCode();
            }
            return hashCode += this.values.hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == null || rhs.getClass() != this.getClass()) {
                return false;
            }
            if (rhs == this) {
                return true;
            }
            Attribute rhsAttribute = (Attribute)rhs;
            String lhsKey = this.getKey();
            String rhsKey = rhsAttribute.getKey();
            if (lhsKey == null && rhsKey != null || lhsKey != null && rhsKey == null || !lhsKey.equals(rhsKey)) {
                return false;
            }
            return CollectionUtils.equals(this.values, rhsAttribute.values);
        }

        public void parse(String line) throws ManifestException {
            int index = line.indexOf(": ");
            if (index == -1) {
                throw new ManifestException("Manifest line \"" + line + "\" is not valid as it does not " + "contain a name and a value separated by ': ' ");
            }
            this.name = line.substring(0, index);
            this.setValue(line.substring(index + 2));
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            if (this.name == null) {
                return null;
            }
            return this.name.toLowerCase();
        }

        public void setValue(String value) {
            if (this.currentIndex >= this.values.size()) {
                this.values.addElement(value);
                this.currentIndex = this.values.size() - 1;
            } else {
                this.values.setElementAt(value, this.currentIndex);
            }
        }

        public String getValue() {
            if (this.values.size() == 0) {
                return null;
            }
            String fullValue = "";
            Enumeration e2 = this.getValues();
            while (e2.hasMoreElements()) {
                String value = (String)e2.nextElement();
                fullValue = fullValue + value + " ";
            }
            return fullValue.trim();
        }

        public void addValue(String value) {
            ++this.currentIndex;
            this.setValue(value);
        }

        public Enumeration getValues() {
            return this.values.elements();
        }

        public void addContinuation(String line) {
            String currentValue = (String)this.values.elementAt(this.currentIndex);
            this.setValue(currentValue + line.substring(1));
        }

        public void write(PrintWriter writer) throws IOException {
            Enumeration e2 = this.getValues();
            while (e2.hasMoreElements()) {
                this.writeValue(writer, (String)e2.nextElement());
            }
        }

        private void writeValue(PrintWriter writer, String value) throws IOException {
            String line = this.name + ": " + value;
            while (line.getBytes().length > 72) {
                int breakIndex = 70;
                String section = line.substring(0, breakIndex);
                while (section.getBytes().length > 70 && breakIndex > 0) {
                    section = line.substring(0, --breakIndex);
                }
                if (breakIndex == 0) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + value);
                }
                writer.print(section + Manifest.EOL);
                line = " " + line.substring(breakIndex);
            }
            writer.print(line + Manifest.EOL);
        }
    }
}

