/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MacroDef;

public class MacroInstance
extends Task
implements DynamicAttribute,
TaskContainer {
    private MacroDef macroDef;
    private Map map = new HashMap();
    private Map nsElements = null;
    private Map presentElements;
    private Hashtable localProperties;
    private String text = null;
    private String implicitTag = null;
    private List unknownElements = new ArrayList();
    private static final int STATE_NORMAL = 0;
    private static final int STATE_EXPECT_BRACKET = 1;
    private static final int STATE_EXPECT_NAME = 2;

    public void setMacroDef(MacroDef macroDef) {
        this.macroDef = macroDef;
    }

    public MacroDef getMacroDef() {
        return this.macroDef;
    }

    public void setDynamicAttribute(String name, String value) {
        this.map.put(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        throw new BuildException("Not implemented any more");
    }

    private Map getNsElements() {
        if (this.nsElements == null) {
            this.nsElements = new HashMap();
            Iterator i = this.macroDef.getElements().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.nsElements.put((String)entry.getKey(), entry.getValue());
                MacroDef.TemplateElement te = (MacroDef.TemplateElement)entry.getValue();
                if (!te.isImplicit()) continue;
                this.implicitTag = te.getName();
            }
        }
        return this.nsElements;
    }

    public void addTask(Task nestedTask) {
        this.unknownElements.add(nestedTask);
    }

    private void processTasks() {
        if (this.implicitTag != null) {
            return;
        }
        Iterator i = this.unknownElements.iterator();
        while (i.hasNext()) {
            UnknownElement ue = (UnknownElement)i.next();
            String name = ProjectHelper.extractNameFromComponentName(ue.getTag()).toLowerCase(Locale.US);
            if (this.getNsElements().get(name) == null) {
                throw new BuildException("unsupported element " + name);
            }
            if (this.presentElements.get(name) != null) {
                throw new BuildException("Element " + name + " already present");
            }
            this.presentElements.put(name, ue.getChildren());
        }
    }

    private String macroSubs(String s, Map macroMapping) {
        if (s == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        StringBuffer macroName = null;
        boolean inMacro = false;
        int state = 0;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '@') {
                        state = 1;
                        break;
                    }
                    ret.append(ch);
                    break;
                }
                case 1: {
                    if (ch == '{') {
                        state = 2;
                        macroName = new StringBuffer();
                        break;
                    }
                    if (ch == '@') {
                        state = 0;
                        ret.append('@');
                        break;
                    }
                    state = 0;
                    ret.append('@');
                    ret.append(ch);
                    break;
                }
                case 2: {
                    if (ch == '}') {
                        state = 0;
                        String name = macroName.toString().toLowerCase(Locale.US);
                        String value = (String)macroMapping.get(name);
                        if (value == null) {
                            ret.append("@{" + name + "}");
                        } else {
                            ret.append(value);
                        }
                        macroName = null;
                        break;
                    }
                    macroName.append(ch);
                    break;
                }
            }
            ++i;
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                ret.append('@');
                break;
            }
            case 2: {
                ret.append("@{");
                ret.append(macroName.toString());
                break;
            }
        }
        return ret.toString();
    }

    public void addText(String text) {
        this.text = text;
    }

    private UnknownElement copy(UnknownElement ue) {
        UnknownElement ret = new UnknownElement(ue.getTag());
        ret.setNamespace(ue.getNamespace());
        ret.setProject(this.getProject());
        ret.setQName(ue.getQName());
        ret.setTaskType(ue.getTaskType());
        ret.setTaskName(ue.getTaskName());
        ret.setLocation(ue.getLocation());
        if (this.getOwningTarget() == null) {
            Target t = new Target();
            t.setProject(this.getProject());
            ret.setOwningTarget(t);
        } else {
            ret.setOwningTarget(this.getOwningTarget());
        }
        RuntimeConfigurable rc = new RuntimeConfigurable(ret, ue.getTaskName());
        rc.setPolyType(ue.getWrapper().getPolyType());
        Hashtable map = ue.getWrapper().getAttributeMap();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            rc.setAttribute((String)entry.getKey(), this.macroSubs((String)entry.getValue(), this.localProperties));
        }
        rc.addText(this.macroSubs(ue.getWrapper().getText().toString(), this.localProperties));
        Enumeration e2 = ue.getWrapper().getChildren();
        while (e2.hasMoreElements()) {
            MacroDef.TemplateElement templateElement;
            RuntimeConfigurable r = (RuntimeConfigurable)e2.nextElement();
            UnknownElement unknownElement = (UnknownElement)r.getProxy();
            String tag = unknownElement.getTaskType();
            if (tag != null) {
                tag = tag.toLowerCase(Locale.US);
            }
            if ((templateElement = (MacroDef.TemplateElement)this.getNsElements().get(tag)) == null) {
                UnknownElement child = this.copy(unknownElement);
                rc.addChild(child.getWrapper());
                ret.addChild(child);
                continue;
            }
            if (templateElement.isImplicit()) {
                if (this.unknownElements.size() == 0 && !templateElement.isOptional()) {
                    throw new BuildException("Missing nested elements for implicit element " + templateElement.getName());
                }
                Iterator i2 = this.unknownElements.iterator();
                while (i2.hasNext()) {
                    UnknownElement child = (UnknownElement)i2.next();
                    rc.addChild(child.getWrapper());
                    ret.addChild(child);
                }
                continue;
            }
            List list = (List)this.presentElements.get(tag);
            if (list == null) {
                if (templateElement.isOptional()) continue;
                throw new BuildException("Required nested element " + templateElement.getName() + " missing");
            }
            Iterator i3 = list.iterator();
            while (i3.hasNext()) {
                UnknownElement child = (UnknownElement)i3.next();
                rc.addChild(child.getWrapper());
                ret.addChild(child);
            }
        }
        return ret;
    }

    public void execute() {
        this.presentElements = new HashMap();
        this.getNsElements();
        this.processTasks();
        this.localProperties = new Hashtable();
        HashSet copyKeys = new HashSet(this.map.keySet());
        Iterator i = this.macroDef.getAttributes().iterator();
        while (i.hasNext()) {
            MacroDef.Attribute attribute = (MacroDef.Attribute)i.next();
            String value = (String)this.map.get(attribute.getName());
            if (value == null && "description".equals(attribute.getName())) {
                value = this.getDescription();
            }
            if (value == null) {
                value = attribute.getDefault();
                value = this.macroSubs(value, this.localProperties);
            }
            if (value == null) {
                throw new BuildException("required attribute " + attribute.getName() + " not set");
            }
            this.localProperties.put(attribute.getName(), value);
            copyKeys.remove(attribute.getName());
        }
        if (copyKeys.contains("id")) {
            copyKeys.remove("id");
        }
        if (this.macroDef.getText() != null) {
            if (this.text == null) {
                if (!this.macroDef.getText().getOptional()) {
                    throw new BuildException("required text missing");
                }
                this.text = "";
            }
            if (this.macroDef.getText().getTrim()) {
                this.text = this.text.trim();
            }
            this.localProperties.put(this.macroDef.getText().getName(), this.text);
        } else if (this.text != null && !this.text.trim().equals("")) {
            throw new BuildException("The \"" + this.getTaskName() + "\" macro does not support" + " nested text data.");
        }
        if (copyKeys.size() != 0) {
            throw new BuildException("Unknown attribute" + (copyKeys.size() > 1 ? "s " : " ") + copyKeys);
        }
        UnknownElement c = this.copy(this.macroDef.getNestedTask());
        c.init();
        try {
            c.perform();
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException(ex, this.getLocation());
        }
        this.presentElements = null;
        this.localProperties = null;
    }

    public static class Element
    implements TaskContainer {
        private List unknownElements = new ArrayList();

        public void addTask(Task nestedTask) {
            this.unknownElements.add(nestedTask);
        }

        public List getUnknownElements() {
            return this.unknownElements;
        }
    }
}

