/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Expand
extends Task {
    private File dest;
    private File source;
    private boolean overwrite = true;
    private Vector patternsets = new Vector();
    private Vector filesets = new Vector();
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";

    public void execute() throws BuildException {
        if ("expand".equals(this.getTaskType())) {
            this.log("!! expand is deprecated. Use unzip instead. !!");
        }
        if (this.source == null && this.filesets.size() == 0) {
            throw new BuildException("src attribute and/or filesets must be specified");
        }
        if (this.dest == null) {
            throw new BuildException("Dest attribute must be specified");
        }
        if (this.dest.exists() && !this.dest.isDirectory()) {
            throw new BuildException("Dest must be a directory.", this.getLocation());
        }
        FileUtils fileUtils = FileUtils.newFileUtils();
        if (this.source != null) {
            if (this.source.isDirectory()) {
                throw new BuildException("Src must not be a directory. Use nested filesets instead.", this.getLocation());
            }
            this.expandFile(fileUtils, this.source, this.dest);
        }
        if (this.filesets.size() > 0) {
            int j = 0;
            while (j < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(j);
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File fromDir = fs.getDir(this.getProject());
                String[] files = ds.getIncludedFiles();
                int i = 0;
                while (i < files.length) {
                    File file = new File(fromDir, files[i]);
                    this.expandFile(fileUtils, file, this.dest);
                    ++i;
                }
                ++j;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        this.log("Expanding: " + srcF + " into " + dir, 2);
        ZipFile zf = null;
        try {
            try {
                zf = new ZipFile(srcF, this.encoding);
                Enumeration e2 = zf.getEntries();
                while (true) {
                    if (!e2.hasMoreElements()) {
                        this.log("expand complete", 3);
                        break;
                    }
                    ZipEntry ze = (ZipEntry)e2.nextElement();
                    this.extractFile(fileUtils, srcF, dir, zf.getInputStream(ze), ze.getName(), new Date(ze.getTime()), ze.isDirectory());
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Error while expanding " + srcF.getPath(), ioe);
            }
            Object var8_8 = null;
            if (zf == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (zf == null) throw throwable;
            try {
                zf.close();
                throw throwable;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e3) {}
        zf.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(FileUtils fileUtils, File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws IOException {
        if (this.patternsets != null && this.patternsets.size() > 0) {
            String name = entryName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            boolean included = false;
            int v = 0;
            while (v < this.patternsets.size()) {
                PatternSet p = (PatternSet)this.patternsets.elementAt(v);
                String[] incls = p.getIncludePatterns(this.getProject());
                if (incls == null || incls.length == 0) {
                    incls = new String[]{"**"};
                }
                int w = 0;
                while (w < incls.length) {
                    String pattern = incls[w].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    if (pattern.endsWith(File.separator)) {
                        pattern = pattern + "**";
                    }
                    if (included = SelectorUtils.matchPath(pattern, name)) break;
                    ++w;
                }
                if (!included) break;
                String[] excls = p.getExcludePatterns(this.getProject());
                if (excls != null) {
                    int w2 = 0;
                    while (w2 < excls.length) {
                        String pattern = excls[w2].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                        if (pattern.endsWith(File.separator)) {
                            pattern = pattern + "**";
                        }
                        boolean bl = included = !SelectorUtils.matchPath(pattern, name);
                        if (!included) break;
                        ++w2;
                    }
                }
                ++v;
            }
            if (!included) {
                return;
            }
        }
        File f = fileUtils.resolveFile(dir, entryName);
        try {
            block22: {
                if (!this.overwrite && f.exists() && f.lastModified() >= entryDate.getTime()) {
                    this.log("Skipping " + f + " as it is up-to-date", 4);
                    return;
                }
                this.log("expanding " + entryName + " to " + f, 3);
                File dirF = fileUtils.getParentFile(f);
                if (dirF != null) {
                    dirF.mkdirs();
                }
                if (isDirectory) {
                    f.mkdirs();
                } else {
                    byte[] buffer = new byte[1024];
                    int length = 0;
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(f);
                        while (true) {
                            if ((length = compressedInputStream.read(buffer)) < 0) {
                                fos.close();
                                fos = null;
                                Object var18_21 = null;
                                if (fos == null) break block22;
                                break;
                            }
                            fos.write(buffer, 0, length);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_22 = null;
                        if (fos == null) throw throwable;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e2) {}
                    fos.close();
                }
            }
            fileUtils.setFileLastModified(f, entryDate.getTime());
            return;
        }
        catch (FileNotFoundException ex) {
            this.log("Unable to expand to file " + f.getPath(), 1);
            return;
        }
    }

    public void setDest(File d) {
        this.dest = d;
    }

    public void setSrc(File s) {
        this.source = s;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public void addPatternset(PatternSet set) {
        this.patternsets.addElement(set);
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }
}

