/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Definer;
import org.apache.tools.ant.taskdefs.Typedef;

public class ComponentHelper {
    private AntTypeTable antTypeTable;
    private Hashtable taskClassDefinitions = new Hashtable();
    private boolean rebuildTaskClassDefinitions = true;
    private Hashtable typeClassDefinitions = new Hashtable();
    private boolean rebuildTypeClassDefinitions = true;
    private Set checkedNamespaces = new HashSet();
    private Stack antLibStack = new Stack();
    private String antLibCurrentUri = null;
    private Hashtable createdTasks = new Hashtable();
    private ComponentHelper next;
    private Project project;
    static /* synthetic */ Class class$org$apache$tools$ant$TaskAdapter;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$Property;

    public static ComponentHelper getComponentHelper(Project project) {
        ComponentHelper ph = (ComponentHelper)project.getReference("ant.ComponentHelper");
        if (ph != null) {
            return ph;
        }
        ph = new ComponentHelper();
        ph.setProject(project);
        project.addReference("ant.ComponentHelper", ph);
        return ph;
    }

    protected ComponentHelper() {
    }

    public void setNext(ComponentHelper next) {
        this.next = next;
    }

    public ComponentHelper getNext() {
        return this.next;
    }

    public void setProject(Project project) {
        this.project = project;
        this.antTypeTable = new AntTypeTable(project);
    }

    public void initSubProject(ComponentHelper helper) {
        AntTypeTable typeTable = helper.antTypeTable;
        Iterator i = typeTable.values().iterator();
        while (i.hasNext()) {
            AntTypeDefinition def = (AntTypeDefinition)i.next();
            this.antTypeTable.put(def.getName(), def);
        }
        Iterator i2 = helper.checkedNamespaces.iterator();
        while (i2.hasNext()) {
            this.checkedNamespaces.add(i2.next());
        }
    }

    public Object createComponent(UnknownElement ue, String ns, String componentType) throws BuildException {
        Object component = this.createComponent(componentType);
        if (component instanceof Task) {
            Task task = (Task)component;
            task.setLocation(ue.getLocation());
            task.setTaskType(componentType);
            task.setTaskName(ue.getTaskName());
            task.setOwningTarget(ue.getOwningTarget());
            task.init();
            this.addCreatedTask(componentType, task);
        }
        return component;
    }

    public Object createComponent(String componentName) {
        AntTypeDefinition def = this.getDefinition(componentName);
        return def == null ? null : def.create(this.project);
    }

    public Class getComponentClass(String componentName) {
        AntTypeDefinition def = this.getDefinition(componentName);
        return def == null ? null : def.getExposedClass(this.project);
    }

    public AntTypeDefinition getDefinition(String componentName) {
        this.checkNamespace(componentName);
        return this.antTypeTable.getDefinition(componentName);
    }

    public void initDefaultDefinitions() {
        this.initTasks();
        this.initTypes();
    }

    public void addTaskDefinition(String taskName, Class taskClass) {
        this.checkTaskClass(taskClass);
        AntTypeDefinition def = new AntTypeDefinition();
        def.setName(taskName);
        def.setClassLoader(taskClass.getClassLoader());
        def.setClass(taskClass);
        def.setAdapterClass(class$org$apache$tools$ant$TaskAdapter == null ? (class$org$apache$tools$ant$TaskAdapter = ComponentHelper.class$("org.apache.tools.ant.TaskAdapter")) : class$org$apache$tools$ant$TaskAdapter);
        def.setClassName(taskClass.getName());
        def.setAdaptToClass(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task);
        this.updateDataTypeDefinition(def);
    }

    public void checkTaskClass(Class taskClass) throws BuildException {
        if (!Modifier.isPublic(taskClass.getModifiers())) {
            String message = taskClass + " is not public";
            this.project.log(message, 0);
            throw new BuildException(message);
        }
        if (Modifier.isAbstract(taskClass.getModifiers())) {
            String message = taskClass + " is abstract";
            this.project.log(message, 0);
            throw new BuildException(message);
        }
        try {
            taskClass.getConstructor(null);
        }
        catch (NoSuchMethodException e2) {
            String message = "No public no-arg constructor in " + taskClass;
            this.project.log(message, 0);
            throw new BuildException(message);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(taskClass)) {
            TaskAdapter.checkTaskClass(taskClass, this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTaskDefinitions() {
        Hashtable hashtable = this.taskClassDefinitions;
        synchronized (hashtable) {
            AntTypeTable antTypeTable = this.antTypeTable;
            synchronized (antTypeTable) {
                if (this.rebuildTaskClassDefinitions) {
                    this.taskClassDefinitions.clear();
                    Iterator i = this.antTypeTable.keySet().iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        Class clazz = this.antTypeTable.getExposedClass(name);
                        if (clazz == null || !(class$org$apache$tools$ant$Task == null ? ComponentHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) continue;
                        this.taskClassDefinitions.put(name, this.antTypeTable.getTypeClass(name));
                    }
                    this.rebuildTaskClassDefinitions = false;
                }
            }
        }
        return this.taskClassDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDataTypeDefinitions() {
        Hashtable hashtable = this.typeClassDefinitions;
        synchronized (hashtable) {
            AntTypeTable antTypeTable = this.antTypeTable;
            synchronized (antTypeTable) {
                if (this.rebuildTypeClassDefinitions) {
                    this.typeClassDefinitions.clear();
                    Iterator i = this.antTypeTable.keySet().iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        Class clazz = this.antTypeTable.getExposedClass(name);
                        if (clazz == null || (class$org$apache$tools$ant$Task == null ? ComponentHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task).isAssignableFrom(clazz)) continue;
                        this.typeClassDefinitions.put(name, this.antTypeTable.getTypeClass(name));
                    }
                    this.rebuildTypeClassDefinitions = false;
                }
            }
        }
        return this.typeClassDefinitions;
    }

    public void addDataTypeDefinition(String typeName, Class typeClass) {
        AntTypeDefinition def = new AntTypeDefinition();
        def.setName(typeName);
        def.setClass(typeClass);
        this.updateDataTypeDefinition(def);
        this.project.log(" +User datatype: " + typeName + "     " + typeClass.getName(), 4);
    }

    public void addDataTypeDefinition(AntTypeDefinition def) {
        this.updateDataTypeDefinition(def);
    }

    public Hashtable getAntTypeTable() {
        return this.antTypeTable;
    }

    public Task createTask(String taskType) throws BuildException {
        Task task = this.createNewTask(taskType);
        if (task == null && taskType.equals("property")) {
            this.addTaskDefinition("property", class$org$apache$tools$ant$taskdefs$Property == null ? (class$org$apache$tools$ant$taskdefs$Property = ComponentHelper.class$("org.apache.tools.ant.taskdefs.Property")) : class$org$apache$tools$ant$taskdefs$Property);
            task = this.createNewTask(taskType);
        }
        if (task != null) {
            this.addCreatedTask(taskType, task);
        }
        return task;
    }

    private Task createNewTask(String taskType) throws BuildException {
        Class c = this.getComponentClass(taskType);
        if (c == null || !(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(c)) {
            return null;
        }
        Task task = (Task)this.createComponent(taskType);
        if (task == null) {
            return null;
        }
        task.setTaskType(taskType);
        task.setTaskName(taskType);
        this.project.log("   +Task: " + taskType, 4);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCreatedTask(String type, Task task) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector<WeakReference<Task>> v = (Vector<WeakReference<Task>>)this.createdTasks.get(type);
            if (v == null) {
                v = new Vector<WeakReference<Task>>();
                this.createdTasks.put(type, v);
            }
            v.addElement(new WeakReference<Task>(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCreatedTasks(String type) {
        Hashtable hashtable = this.createdTasks;
        synchronized (hashtable) {
            Vector v = (Vector)this.createdTasks.get(type);
            if (v != null) {
                Enumeration taskEnum = v.elements();
                while (taskEnum.hasMoreElements()) {
                    WeakReference ref = (WeakReference)taskEnum.nextElement();
                    Task t = (Task)ref.get();
                    if (t == null) continue;
                    t.markInvalid();
                }
                v.removeAllElements();
                this.createdTasks.remove(type);
            }
        }
    }

    public Object createDataType(String typeName) throws BuildException {
        return this.createComponent(typeName);
    }

    public String getElementName(Object element) {
        Class<?> elementClass = element.getClass();
        Iterator i = this.antTypeTable.values().iterator();
        while (i.hasNext()) {
            AntTypeDefinition def = (AntTypeDefinition)i.next();
            if (elementClass != def.getExposedClass(this.project)) continue;
            return "The <" + def.getName() + "> type";
        }
        return "Class " + elementClass.getName();
    }

    private boolean validDefinition(AntTypeDefinition def) {
        return def.getTypeClass(this.project) != null && def.getExposedClass(this.project) != null;
    }

    private boolean sameDefinition(AntTypeDefinition def, AntTypeDefinition old) {
        boolean defValid = this.validDefinition(def);
        boolean sameValidity = defValid == this.validDefinition(old);
        return sameValidity && (!defValid || def.sameDefinition(old, this.project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeDefinition(AntTypeDefinition def) {
        String name = def.getName();
        AntTypeTable antTypeTable = this.antTypeTable;
        synchronized (antTypeTable) {
            this.rebuildTaskClassDefinitions = true;
            this.rebuildTypeClassDefinitions = true;
            AntTypeDefinition old = this.antTypeTable.getDefinition(name);
            if (old != null) {
                if (this.sameDefinition(def, old)) {
                    return;
                }
                Class oldClass = this.antTypeTable.getExposedClass(name);
                boolean isTask = oldClass != null && (class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = ComponentHelper.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(oldClass);
                this.project.log("Trying to override old definition of " + (isTask ? "task " : "datatype ") + name, def.similarDefinition(old, this.project) ? 3 : 1);
                if (isTask) {
                    this.invalidateCreatedTasks(name);
                }
            }
            this.project.log(" +Datatype " + name + " " + def.getClassName(), 4);
            this.antTypeTable.put(name, def);
        }
    }

    public void enterAntLib(String uri) {
        this.antLibCurrentUri = uri;
        this.antLibStack.push(uri);
    }

    public String getCurrentAntlibUri() {
        return this.antLibCurrentUri;
    }

    public void exitAntLib() {
        this.antLibStack.pop();
        this.antLibCurrentUri = this.antLibStack.size() == 0 ? null : (String)this.antLibStack.peek();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTasks() {
        ClassLoader classLoader = null;
        if (this.project.getCoreLoader() != null && !"only".equals(this.project.getProperty("build.sysclasspath"))) {
            classLoader = this.project.getCoreLoader();
        }
        String dataDefs = "/org/apache/tools/ant/taskdefs/defaults.properties";
        InputStream in = null;
        try {
            try {
                Properties props = new Properties();
                in = this.getClass().getResourceAsStream(dataDefs);
                if (in == null) {
                    throw new BuildException("Can't load default task list");
                }
                props.load(in);
                Enumeration<?> e2 = props.propertyNames();
                while (e2.hasMoreElements()) {
                    String name = (String)e2.nextElement();
                    String className = props.getProperty(name);
                    AntTypeDefinition def = new AntTypeDefinition();
                    def.setName(name);
                    def.setClassName(className);
                    def.setClassLoader(classLoader);
                    def.setAdaptToClass(class$org$apache$tools$ant$Task == null ? ComponentHelper.class$("org.apache.tools.ant.Task") : class$org$apache$tools$ant$Task);
                    def.setAdapterClass(class$org$apache$tools$ant$TaskAdapter == null ? ComponentHelper.class$("org.apache.tools.ant.TaskAdapter") : class$org$apache$tools$ant$TaskAdapter);
                    this.antTypeTable.put(name, def);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Can't load default type list");
            }
            Object var10_10 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        in.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initTypes() {
        ClassLoader classLoader = null;
        if (this.project.getCoreLoader() != null && !"only".equals(this.project.getProperty("build.sysclasspath"))) {
            classLoader = this.project.getCoreLoader();
        }
        String dataDefs = "/org/apache/tools/ant/types/defaults.properties";
        InputStream in = null;
        try {
            try {
                Properties props = new Properties();
                in = this.getClass().getResourceAsStream(dataDefs);
                if (in == null) {
                    throw new BuildException("Can't load default datatype list");
                }
                props.load(in);
                Enumeration<?> e2 = props.propertyNames();
                while (e2.hasMoreElements()) {
                    String name = (String)e2.nextElement();
                    String className = props.getProperty(name);
                    AntTypeDefinition def = new AntTypeDefinition();
                    def.setName(name);
                    def.setClassName(className);
                    def.setClassLoader(classLoader);
                    this.antTypeTable.put(name, def);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Can't load default type list");
            }
            Object var10_10 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        in.close();
        return;
    }

    private synchronized void checkNamespace(String componentName) {
        String uri = ProjectHelper.extractUriFromComponentName(componentName);
        if ("".equals(uri)) {
            uri = "antlib:org.apache.tools.ant";
        }
        if (!uri.startsWith("antlib:")) {
            return;
        }
        if (this.checkedNamespaces.contains(uri)) {
            return;
        }
        this.checkedNamespaces.add(uri);
        Typedef definer = new Typedef();
        definer.setProject(this.project);
        definer.setURI(uri);
        definer.setResource(uri.substring("antlib:".length()).replace('.', '/') + "/antlib.xml");
        definer.setOnError(new Definer.OnError("ignore"));
        definer.init();
        definer.execute();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AntTypeTable
    extends Hashtable {
        private Project project;

        public AntTypeTable(Project project) {
            this.project = project;
        }

        public AntTypeDefinition getDefinition(String key) {
            return (AntTypeDefinition)super.get(key);
        }

        public Object get(Object key) {
            return this.getTypeClass((String)key);
        }

        public Object create(String name) {
            AntTypeDefinition def = this.getDefinition(name);
            return def == null ? null : def.create(this.project);
        }

        public Class getTypeClass(String name) {
            AntTypeDefinition def = this.getDefinition(name);
            return def == null ? null : def.getTypeClass(this.project);
        }

        public Class getExposedClass(String name) {
            AntTypeDefinition def = this.getDefinition(name);
            return def == null ? null : def.getExposedClass(this.project);
        }

        public boolean contains(Object clazz) {
            boolean found = false;
            if (clazz instanceof Class) {
                Iterator i = this.values().iterator();
                while (i.hasNext() && !found) {
                    found |= ((AntTypeDefinition)i.next()).getExposedClass(this.project) == clazz;
                }
            }
            return found;
        }

        public boolean containsValue(Object value) {
            return this.contains(value);
        }
    }
}

