/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.taglibs.standard.tag.common.xml.UnresolvableException;

public class JSTLXPathVariableResolver
implements XPathVariableResolver {
    private PageContext pageContext;
    private static final String PAGE_NS_URL = "http://java.sun.com/jstl/xpath/page";
    private static final String REQUEST_NS_URL = "http://java.sun.com/jstl/xpath/request";
    private static final String SESSION_NS_URL = "http://java.sun.com/jstl/xpath/session";
    private static final String APP_NS_URL = "http://java.sun.com/jstl/xpath/app";
    private static final String PARAM_NS_URL = "http://java.sun.com/jstl/xpath/param";
    private static final String INITPARAM_NS_URL = "http://java.sun.com/jstl/xpath/initParam";
    private static final String COOKIE_NS_URL = "http://java.sun.com/jstl/xpath/cookie";
    private static final String HEADER_NS_URL = "http://java.sun.com/jstl/xpath/header";

    public JSTLXPathVariableResolver(PageContext pc) {
        this.pageContext = pc;
    }

    public Object resolveVariable(QName qname) throws NullPointerException {
        Object varObject = null;
        if (qname == null) {
            throw new NullPointerException("Cannot resolve null variable");
        }
        String namespace2 = qname.getNamespaceURI();
        String prefix = qname.getPrefix();
        String localName = qname.getLocalPart();
        try {
            varObject = this.getVariableValue(namespace2, prefix, localName);
        }
        catch (UnresolvableException ue) {
            System.out.println("JSTLXpathVariableResolver.resolveVariable threw UnresolvableException: " + ue);
        }
        return varObject;
    }

    protected Object getVariableValue(String namespace2, String prefix, String localName) throws UnresolvableException {
        if (namespace2 == null || namespace2.equals("")) {
            return this.notNull(this.pageContext.findAttribute(localName), namespace2, localName);
        }
        if (namespace2.equals(PAGE_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 1), namespace2, localName);
        }
        if (namespace2.equals(REQUEST_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 2), namespace2, localName);
        }
        if (namespace2.equals(SESSION_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 3), namespace2, localName);
        }
        if (namespace2.equals(APP_NS_URL)) {
            return this.notNull(this.pageContext.getAttribute(localName, 4), namespace2, localName);
        }
        if (namespace2.equals(PARAM_NS_URL)) {
            return this.notNull(this.pageContext.getRequest().getParameter(localName), namespace2, localName);
        }
        if (namespace2.equals(INITPARAM_NS_URL)) {
            return this.notNull(this.pageContext.getServletContext().getInitParameter(localName), namespace2, localName);
        }
        if (namespace2.equals(HEADER_NS_URL)) {
            HttpServletRequest hsr = (HttpServletRequest)this.pageContext.getRequest();
            return this.notNull(hsr.getHeader(localName), namespace2, localName);
        }
        if (namespace2.equals(COOKIE_NS_URL)) {
            HttpServletRequest hsr = (HttpServletRequest)this.pageContext.getRequest();
            Cookie[] c = hsr.getCookies();
            for (int i = 0; i < c.length; ++i) {
                if (!c[i].getName().equals(localName)) continue;
                return c[i].getValue();
            }
            throw new UnresolvableException("$" + namespace2 + ":" + localName);
        }
        throw new UnresolvableException("$" + namespace2 + ":" + localName);
    }

    private Object notNull(Object o, String namespace2, String localName) throws UnresolvableException {
        if (o == null) {
            throw new UnresolvableException("$" + (namespace2 == null ? "" : namespace2 + ":") + localName);
        }
        return o;
    }

    private static void p(String s) {
        System.out.println("[JSTLXPathVariableResolver] " + s);
    }
}

