/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.runtime.ResourceInjector;

public class TagHandlerPool {
    public static final String OPTION_TAGPOOL = "tagpoolClassName";
    public static final String OPTION_MAXSIZE = "tagpoolMaxSize";
    private Tag[] handlers;
    private ResourceInjector resourceInjector;
    private int current;

    public static TagHandlerPool getTagHandlerPool(ServletConfig config) {
        TagHandlerPool result = null;
        String tpClassName = TagHandlerPool.getOption(config, OPTION_TAGPOOL, null);
        if (tpClassName != null) {
            try {
                Class<?> c = Class.forName(tpClassName);
                result = (TagHandlerPool)c.newInstance();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                result = null;
            }
        }
        if (result == null) {
            result = new TagHandlerPool();
        }
        result.init(config);
        return result;
    }

    protected void init(ServletConfig config) {
        int maxSize = -1;
        String maxSizeS = TagHandlerPool.getOption(config, OPTION_MAXSIZE, null);
        if (maxSizeS != null) {
            try {
                maxSize = Integer.parseInt(maxSizeS);
            }
            catch (Exception ex) {
                maxSize = -1;
            }
        }
        if (maxSize < 0) {
            maxSize = 5;
        }
        this.handlers = new Tag[maxSize];
        this.current = -1;
        this.resourceInjector = (ResourceInjector)config.getServletContext().getAttribute("com.sun.appserv.jsp.resource.injector");
    }

    public TagHandlerPool() {
    }

    public TagHandlerPool(int capacity) {
        this.handlers = new Tag[capacity];
        this.current = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag get(Class handlerClass) throws JspException {
        Tag handler = null;
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                handler = this.handlers[this.current--];
                return handler;
            }
        }
        Tag tagHandler = null;
        try {
            tagHandler = (Tag)handlerClass.newInstance();
            if (this.resourceInjector != null) {
                this.resourceInjector.inject(tagHandler);
            }
        }
        catch (Exception e2) {
            throw new JspException(e2.getMessage(), e2);
        }
        return tagHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(Tag handler) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = handler;
                return;
            }
        }
        handler.release();
        if (this.resourceInjector != null) {
            this.resourceInjector.preDestroy(handler);
        }
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            this.handlers[i].release();
            if (this.resourceInjector == null) continue;
            this.resourceInjector.preDestroy(this.handlers[i]);
        }
    }

    protected static String getOption(ServletConfig config, String name, String defaultV) {
        if (config == null) {
            return defaultV;
        }
        String value = config.getInitParameter(name);
        if (value != null) {
            return value;
        }
        if (config.getServletContext() == null) {
            return defaultV;
        }
        value = config.getServletContext().getInitParameter(name);
        if (value != null) {
            return value;
        }
        return defaultV;
    }
}

