/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicCookieStore
implements CookieStore,
Serializable {
    private static final long serialVersionUID = -1113466491038527240L;
    @GuardedBy(value="this")
    private final ArrayList<Cookie> cookies = new ArrayList();
    @GuardedBy(value="this")
    private final Comparator<Cookie> cookieComparator = new CookieIdentityComparator();

    @Override
    public synchronized void addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator<Cookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                if (this.cookieComparator.compare(cookie, it.next()) != 0) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cooky : cookies) {
                this.addCookie(cooky);
            }
        }
    }

    @Override
    public synchronized List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies);
    }

    @Override
    public synchronized boolean clearExpired(Date date2) {
        if (date2 == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Cookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired(date2)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public String toString() {
        return this.cookies.toString();
    }

    @Override
    public synchronized void clear() {
        this.cookies.clear();
    }
}

