/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store.bulkloader;

import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.store.bulkloader.BulkLoader;
import org.openjena.atlas.event.Event;
import org.openjena.atlas.event.EventManager;
import org.slf4j.Logger;

public final class LoadMonitor {
    private final Logger log;
    private final DatasetGraph dataset;
    private final long superTick = BulkLoader.superTick;
    private final long dataTickPoint;
    private final long indexTickPoint;
    protected final Timer timer;
    private long processStartTime = 0L;
    private long processFinishTime = 0L;
    private long processTime = 0L;
    private long totalDataItems = 0L;
    private long dataStartTime = 0L;
    private long dataFinishTime = 0L;
    private long dataTime = 0L;
    private long totalIndexItems = 0L;
    private long indexStartTime = 0L;
    private long indexFinishTime = 0L;
    private long indexTime = 0L;
    private long currentItems = 0L;
    private long lastTime = 0L;
    private long currentStartTime = 0L;
    private long currentFinishTime = 0L;
    private long elapsedLastTime = 0L;
    private String itemsName;
    String indexLabel;

    public LoadMonitor(DatasetGraph dsg, Logger log, String itemsName, long dataTickPoint, long indexTickPoint) {
        this.dataset = dsg;
        this.log = log;
        this.itemsName = itemsName;
        this.dataTickPoint = dataTickPoint;
        this.indexTickPoint = indexTickPoint;
        this.timer = new Timer();
    }

    public void startLoad() {
        EventManager.send(this.dataset, new Event(BulkLoader.evStartBulkload, null));
        this.timer.startTimer();
        this.processStartTime = this.timer.readTimer();
    }

    public void finishLoad() {
        this.timer.endTimer();
        this.processFinishTime = this.timer.getTimeInterval();
        this.processTime = this.processFinishTime - this.processStartTime;
        this.print("-- Finish %s load", this.itemsName);
        if (this.totalDataItems > 0L) {
            this.print("** Completed: %,d %s loaded in %,.2f seconds [Rate: %,.2f per second]", this.totalDataItems, this.itemsName, Float.valueOf((float)this.processTime / 1000.0f), Float.valueOf(1000.0f * (float)this.totalDataItems / (float)this.processTime));
        }
        EventManager.send(this.dataset, new Event(BulkLoader.evFinishBulkload, null));
    }

    public void startDataPhase() {
        this.print("-- Start %s data phase", this.itemsName);
        this.currentStartTime = this.dataStartTime = this.timer.readTimer();
        this.elapsedLastTime = this.dataStartTime;
        this.currentItems = 0L;
        this.totalDataItems = 0L;
        EventManager.send(this.dataset, new Event(BulkLoader.evStartDataBulkload, null));
    }

    public void finishDataPhase() {
        EventManager.send(this.dataset, new Event(BulkLoader.evFinishDataBulkload, null));
        this.dataFinishTime = this.timer.readTimer();
        this.dataTime = this.dataFinishTime - this.dataStartTime;
        this.print("-- Finish %s data phase", this.itemsName);
        if (this.totalDataItems > 0L) {
            this.print("%,d %s loaded in %,.2f seconds [Rate: %,.2f per second]", this.totalDataItems, this.itemsName, Float.valueOf((float)this.dataTime / 1000.0f), Float.valueOf(1000.0f * (float)this.totalDataItems / (float)this.dataTime));
        }
    }

    public final void dataItem() {
        ++this.currentItems;
        ++this.totalDataItems;
        if (LoadMonitor.tickPoint(this.totalDataItems, this.dataTickPoint)) {
            long readTime = this.timer.readTimer();
            long timePoint = readTime - this.currentStartTime;
            long thisTime = timePoint - this.lastTime;
            long batchAvgRate = this.currentItems * 1000L / thisTime;
            long runAvgRate = this.totalDataItems * 1000L / timePoint;
            this.print("Add: %,d %s (Batch: %,d / Avg: %,d)", this.totalDataItems, this.itemsName, batchAvgRate, runAvgRate);
            this.lastTime = timePoint;
            if (LoadMonitor.tickPoint(this.totalDataItems, this.superTick * this.dataTickPoint)) {
                this.elapsed(readTime);
            }
            this.currentItems = 0L;
            this.lastTime = timePoint;
        }
    }

    public void startIndexPhase() {
        this.print("-- Start %s index phase", this.itemsName);
        this.indexStartTime = this.timer.readTimer();
        this.currentItems = 0L;
        EventManager.send(this.dataset, new Event(BulkLoader.evStartIndexBulkload, null));
    }

    public void finishIndexPhase() {
        EventManager.send(this.dataset, new Event(BulkLoader.evFinishIndexBulkload, null));
        this.indexFinishTime = this.timer.readTimer();
        this.indexTime = this.indexFinishTime - this.indexStartTime;
        this.print("-- Finish %s index phase", this.itemsName);
        if (this.totalIndexItems > 0L) {
            if (this.indexTime > 0L) {
                this.print("** %,d %s indexed in %,.2f seconds [Rate: %,.2f per second]", this.totalIndexItems, this.itemsName, Float.valueOf((float)this.indexTime / 1000.0f), Float.valueOf(1000.0f * (float)this.totalIndexItems / (float)this.indexTime));
            } else {
                this.print("** %,d %s indexed", this.totalIndexItems, this.itemsName);
            }
        }
    }

    public void startIndex(String label) {
        this.currentStartTime = this.timer.readTimer();
        this.indexLabel = label;
        this.currentItems = 0L;
        this.totalIndexItems = 0L;
        this.elapsedLastTime = this.currentStartTime;
        this.lastTime = 0L;
    }

    public void finishIndex(String label) {
        this.currentFinishTime = this.timer.readTimer();
        long indexTime = this.currentFinishTime - this.currentStartTime;
        if (this.totalIndexItems > 0L) {
            if (indexTime > 0L) {
                this.print("** Index %s: %,d slots indexed in %,.2f seconds [Rate: %,.2f per second]", label, this.totalIndexItems, Float.valueOf((float)indexTime / 1000.0f), Float.valueOf(1000.0f * (float)this.totalIndexItems / (float)indexTime));
            } else {
                this.print("** Index %s: %,d slots indexed", label, this.totalIndexItems);
            }
        }
    }

    final void indexItem() {
        ++this.currentItems;
        ++this.totalIndexItems;
        if (LoadMonitor.tickPoint(this.totalIndexItems, this.indexTickPoint)) {
            long readTimer = this.timer.readTimer();
            long timePoint = readTimer - this.currentStartTime;
            long thisTime = timePoint - this.lastTime;
            long batchAvgRate = this.currentItems * 1000L / thisTime;
            long runAvgRate = this.totalIndexItems * 1000L / timePoint;
            this.print("Index %s: %,d slots (Batch: %,d slots/s / Avg: %,d slots/s)", this.indexLabel, this.totalIndexItems, batchAvgRate, runAvgRate);
            if (LoadMonitor.tickPoint(this.totalIndexItems, this.superTick * this.indexTickPoint)) {
                this.elapsed(this.timer.readTimer());
            }
            this.currentItems = 0L;
            this.lastTime = timePoint;
        }
    }

    public void print(String fmt, Object ... args) {
        if (this.log != null && this.log.isInfoEnabled()) {
            String str2 = String.format(fmt, args);
            this.log.info(str2);
        }
    }

    private void elapsed(long timerReading) {
        float elapsedSecs = (float)(timerReading - this.processStartTime) / 1000.0f;
        this.print("  Elapsed: %,.2f seconds [%s]", Float.valueOf(elapsedSecs), Utils.nowAsString());
    }

    private static boolean tickPoint(long counter, long quantum) {
        return counter % quantum == 0L;
    }

    private static String num(long v) {
        return StringUtils.str(v);
    }

    private static String num(float value) {
        return StringUtils.str(value);
    }
}

