/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.store.DateTimeNode;
import com.hp.hpl.jena.tdb.store.DecimalNode;
import com.hp.hpl.jena.tdb.store.IntegerNode;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.openjena.atlas.lib.BitsLong;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.logging.Log;

public final class NodeId {
    public static final NodeId NodeDoesNotExist = new NodeId(-8L);
    public static final NodeId NodeIdAny = new NodeId(-9L);
    private static boolean enableInlineLiterals = true;
    public static final int SIZE = 8;
    final long value;
    public static final int NONE = 0;
    public static final int INTEGER = 1;
    public static final int DECIMAL = 2;
    public static final int DATE = 3;
    public static final int DATETIME = 4;
    public static final int BOOLEAN = 5;
    public static final int SHORT_STRING = 6;
    public static final int SPECIAL = 255;

    public static NodeId create(long value) {
        if (value == NodeId.NodeDoesNotExist.value) {
            return NodeDoesNotExist;
        }
        if (value == NodeId.NodeIdAny.value) {
            return NodeIdAny;
        }
        return new NodeId(value);
    }

    public static NodeId create(byte[] b) {
        return NodeId.create(b, 0);
    }

    public static NodeId create(ByteBuffer b) {
        return NodeId.create(b, 0);
    }

    public static NodeId create(byte[] b, int idx) {
        long value = Bytes.getLong(b, idx);
        return NodeId.create(value);
    }

    public static NodeId create(ByteBuffer b, int idx) {
        long value = b.getLong(idx);
        return NodeId.create(value);
    }

    public NodeId(long v) {
        this.value = v;
    }

    public void toByteBuffer(ByteBuffer b, int idx) {
        b.putLong(idx, this.value);
    }

    public void toBytes(byte[] b, int idx) {
        Bytes.setLong(this.value, b, idx);
    }

    public boolean isDirect() {
        return this.type() != 0 && this.type() != 255;
    }

    public int type() {
        return (int)BitsLong.unpack(this.value, 56, 64);
    }

    static long setType(long value, int type) {
        return BitsLong.pack(value, type, 56, 64);
    }

    public long getId() {
        return this.value;
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >> 32);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NodeId)) {
            return false;
        }
        return this.value == ((NodeId)other).value;
    }

    public String toString() {
        if (this == NodeDoesNotExist) {
            return "[DoesNotExist]";
        }
        if (this == NodeIdAny) {
            return "[Any]";
        }
        return String.format("[%016X]", this.value);
    }

    public static NodeId inline(Node node) {
        if (node == null) {
            Log.warn(NodeId.class, "Null node: " + node);
            return null;
        }
        if (!node.isLiteral()) {
            return null;
        }
        if (node.getLiteralDatatype() == null) {
            return null;
        }
        if (!enableInlineLiterals) {
            return null;
        }
        LiteralLabel lit = node.getLiteral();
        if (node.getLiteralDatatype().equals(XSDDatatype.XSDdecimal)) {
            if (!XSDDatatype.XSDdecimal.isValidLiteral(lit)) {
                return null;
            }
            BigDecimal decimal = new BigDecimal(lit.getLexicalForm().trim());
            DecimalNode dn = DecimalNode.valueOf(decimal);
            if (dn != null) {
                return new NodeId(dn.pack());
            }
            return null;
        }
        if (XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            long v = ((Number)lit.getValue()).longValue();
            if ((v = IntegerNode.pack(v)) != -1L) {
                return new NodeId(v);
            }
            return null;
        }
        if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
            long v = DateTimeNode.packDateTime(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            v = NodeId.setType(v, 4);
            return new NodeId(v);
        }
        if (XSDDatatype.XSDdate.isValidLiteral(lit)) {
            long v = DateTimeNode.packDate(lit.getLexicalForm());
            if (v == -1L) {
                return null;
            }
            v = NodeId.setType(v, 3);
            return new NodeId(v);
        }
        if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
            long v = 0L;
            boolean b = (Boolean)lit.getValue();
            v = NodeId.setType(v, 5);
            if (b) {
                v |= 1L;
            }
            return new NodeId(v);
        }
        return null;
    }

    public static Node extract(NodeId nodeId) {
        if (nodeId == NodeDoesNotExist) {
            return null;
        }
        long v = nodeId.value;
        int type = nodeId.type();
        switch (type) {
            case 0: {
                return null;
            }
            case 255: {
                return null;
            }
            case 1: {
                long val = IntegerNode.unpack(v);
                Node n = Node.createLiteral(Long.toString(val), null, XSDDatatype.XSDinteger);
                return n;
            }
            case 2: {
                BigDecimal d = DecimalNode.unpackAsBigDecimal(v);
                String x = d.toEngineeringString();
                return Node.createLiteral(x, null, XSDDatatype.XSDdecimal);
            }
            case 4: {
                long val = BitsLong.clear(v, 56, 64);
                String lex = DateTimeNode.unpackDateTime(val);
                return Node.createLiteral(lex, null, XSDDatatype.XSDdateTime);
            }
            case 3: {
                long val = BitsLong.clear(v, 56, 64);
                String lex = DateTimeNode.unpackDate(val);
                return Node.createLiteral(lex, null, XSDDatatype.XSDdate);
            }
            case 5: {
                long val = BitsLong.clear(v, 56, 64);
                if (val == 0L) {
                    return NodeConst.nodeFalse;
                }
                if (val == 1L) {
                    return NodeConst.nodeTrue;
                }
                throw new TDBException("Unrecognized boolean node id : " + val);
            }
        }
        throw new TDBException("Unrecognized node id type: " + type);
    }

    public static final boolean isAny(NodeId nodeId) {
        return nodeId == NodeIdAny || nodeId == null;
    }

    public static final boolean doesNotExist(NodeId nodeId) {
        return nodeId == NodeDoesNotExist;
    }
}

