/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTriplesTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphTriplesTDB.class);
    private final TripleTable tripleTable;
    private final DatasetPrefixStorage prefixes;

    public GraphTriplesTDB(DatasetGraphTDB dataset, TripleTable tripleTable, DatasetPrefixStorage prefixes) {
        super(dataset, null);
        this.tripleTable = tripleTable;
        this.prefixes = prefixes;
    }

    @Override
    protected boolean _performAdd(Triple t) {
        boolean changed = this.tripleTable.add(t);
        if (!changed) {
            this.duplicate(t);
        }
        return changed;
    }

    @Override
    protected boolean _performDelete(Triple t) {
        boolean changed = this.tripleTable.delete(t);
        return changed;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return this.graphBaseFindWorker(this.tripleTable, m);
    }

    @Override
    protected final Logger getLog() {
        return log;
    }

    @Override
    public Tuple<Node> asTuple(Triple triple) {
        return Tuple.create(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        return this.tripleTable.getNodeTupleTable().getTupleTable().getIndex(0).all();
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        return this.tripleTable.getNodeTupleTable();
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return this.prefixes.getPrefixMapping();
    }

    @Override
    public final void close() {
        if (this.dataset != null) {
            this.sync(true);
        } else {
            this.prefixes.close();
            this.tripleTable.close();
            super.close();
        }
    }

    @Override
    public void sync(boolean force) {
        if (this.dataset != null) {
            this.dataset.sync(force);
        } else {
            this.prefixes.sync(force);
            this.tripleTable.sync(force);
        }
    }

    @Override
    public String toString() {
        return Utils.className(this);
    }
}

