/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Reifier2;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.graph.GraphBase2;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.graph.BulkUpdateHandlerTDB;
import com.hp.hpl.jena.tdb.graph.GraphSyncListener;
import com.hp.hpl.jena.tdb.graph.QueryHandlerTDB;
import com.hp.hpl.jena.tdb.graph.TransactionHandlerTDB;
import com.hp.hpl.jena.tdb.graph.UpdateListener;
import com.hp.hpl.jena.tdb.lib.NodeFmtLib;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openjena.atlas.iterator.Iter;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphTDBBase
extends GraphBase2
implements GraphTDB {
    private final QueryHandlerTDB queryHandler = new QueryHandlerTDB(this);
    private final TransactionHandler transactionHandler = new TransactionHandlerTDB(this);
    private final BulkUpdateHandler bulkUpdateHandler = new BulkUpdateHandlerTDB(this);
    protected final DatasetGraphTDB dataset;
    protected final Node graphNode;
    protected final int syncPoint;
    private long epoch = 4L;

    public GraphTDBBase(DatasetGraphTDB dataset, Node graphName) {
        this.dataset = dataset;
        this.graphNode = graphName;
        this.syncPoint = dataset.getConfigValueAsInt("tdb.synctick", SystemTDB.SyncTick);
        if (this.syncPoint > 0) {
            this.getEventManager().register(new GraphSyncListener(this, this.syncPoint));
        }
        this.getEventManager().register(new UpdateListener(this));
    }

    @Override
    public final ReorderTransformation getReorderTransform() {
        return this.dataset.getTransform();
    }

    @Override
    public final Location getLocation() {
        return this.dataset.getLocation();
    }

    @Override
    public final Node getGraphNode() {
        return this.graphNode;
    }

    @Override
    public final DatasetGraphTDB getDataset() {
        return this.dataset;
    }

    @Override
    public Lock getLock() {
        return this.dataset.getLock();
    }

    @Override
    public final void performAdd(Triple triple) {
        this.startUpdate();
        this._performAdd(triple);
        this.finishUpdate();
    }

    @Override
    public final void performDelete(Triple triple) {
        this.startUpdate();
        this._performDelete(triple);
        this.finishUpdate();
    }

    protected abstract boolean _performAdd(Triple var1);

    protected abstract boolean _performDelete(Triple var1);

    @Override
    public void sync() {
        this.sync(true);
    }

    @Override
    public abstract void sync(boolean var1);

    @Override
    public abstract String toString();

    protected void duplicate(Triple t) {
        if (TDB.getContext().isTrue(SystemTDB.symLogDuplicates) && this.getLog().isInfoEnabled()) {
            String $ = NodeFmtLib.displayStr(t, this.getPrefixMapping());
            this.getLog().info("Duplicate: (" + $ + ")");
        }
    }

    protected ExtendedIterator<Triple> graphBaseFindWorker(TripleTable tripleTable, TripleMatch m) {
        Iterator<Triple> iter = tripleTable.find(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
        if (iter == null) {
            return NullIterator.instance();
        }
        boolean b = iter.hasNext();
        return new MapperIteratorTriples(iter, this);
    }

    protected ExtendedIterator<Triple> graphBaseFindWorker(DatasetGraphTDB dataset, Node graphNode, TripleMatch m) {
        Iterator<Quad> iter;
        Node gn = graphNode;
        if (Quad.isQuadUnionGraph(gn)) {
            gn = Node.ANY;
        }
        if ((iter = dataset.getQuadTable().find(gn, m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject())) == null) {
            return NullIterator.instance();
        }
        Iterator<Triple> iterTriples = new ProjectQuadsToTriples(gn == Node.ANY ? null : gn, iter);
        if (gn == Node.ANY) {
            iterTriples = Iter.distinct(iterTriples);
        }
        return new MapperIteratorTriples(iterTriples, this);
    }

    @Override
    protected Reifier constructReifier() {
        return new Reifier2(this);
    }

    protected abstract Logger getLog();

    protected abstract Iterator<?> countThis();

    @Override
    public void finishRead() {
    }

    @Override
    public void startRead() {
    }

    @Override
    public final void startUpdate() {
        ++this.epoch;
    }

    @Override
    public final void finishUpdate() {
        ++this.epoch;
    }

    @Override
    protected final int graphBaseSize() {
        Iterator<?> iter = this.countThis();
        return (int)Iter.count(iter);
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        return this.bulkUpdateHandler;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new Capabilities(){

                public boolean sizeAccurate() {
                    return true;
                }

                public boolean addAllowed() {
                    return true;
                }

                public boolean addAllowed(boolean every) {
                    return true;
                }

                public boolean deleteAllowed() {
                    return true;
                }

                public boolean deleteAllowed(boolean every) {
                    return true;
                }

                public boolean canBeEmpty() {
                    return true;
                }

                public boolean iteratorRemoveAllowed() {
                    return false;
                }

                public boolean findContractSafe() {
                    return true;
                }

                public boolean handlesLiteralTyping() {
                    return false;
                }
            };
        }
        return super.getCapabilities();
    }

    @Override
    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProjectQuadsToTriples
    implements Iterator<Triple> {
        private final Iterator<Quad> iter;
        private final Node graphNode;

        ProjectQuadsToTriples(Node graphNode, Iterator<Quad> iter) {
            this.graphNode = graphNode;
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Triple next() {
            Quad q = this.iter.next();
            if (this.graphNode != null && !q.getGraph().equals(this.graphNode)) {
                throw new InternalError("ProjectQuadsToTriples: Quads from unexpected graph");
            }
            return q.asTriple();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapperIteratorTriples
    extends NiceIterator<Triple> {
        private final Iterator<Triple> iter;
        private GraphTDBBase base;
        private long epoch;
        private boolean finished = false;

        MapperIteratorTriples(Iterator<Triple> iter, GraphTDBBase base) {
            this.iter = iter;
            this.base = base;
            this.epoch = base.epoch;
            this.finished = !iter.hasNext();
        }

        private void checkCourrentModification() {
            if (this.finished) {
                return;
            }
            long now2 = this.base.epoch;
            if (now2 != this.epoch) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkCourrentModification();
            boolean b = this.iter.hasNext();
            if (!b) {
                this.finished = true;
            }
            return b;
        }

        @Override
        public Triple next() {
            this.checkCourrentModification();
            try {
                Triple t = this.iter.next();
                if (!this.iter.hasNext()) {
                    this.finished = true;
                }
                return t;
            }
            catch (NoSuchElementException ex) {
                this.finished = true;
                throw ex;
            }
        }

        @Override
        public void remove() {
            this.checkCourrentModification();
            this.iter.remove();
            this.epoch = this.base.epoch;
        }
    }
}

