/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTDBBase;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.openjena.atlas.lib.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNamedTDB
extends GraphTDBBase {
    private static Logger log = LoggerFactory.getLogger(GraphNamedTDB.class);
    private final QuadTable quadTable;
    private NodeId graphNodeId = null;

    public GraphNamedTDB(DatasetGraphTDB dataset, Node graphName) {
        super(dataset, graphName);
        this.quadTable = dataset.getQuadTable();
        if (graphName == null) {
            throw new TDBException("GraphNamedTDB: Null graph name");
        }
        if (!graphName.isURI()) {
            throw new TDBException("GraphNamedTDB: Graph name not a URI");
        }
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return this.dataset.getPrefixes().getPrefixMapping(this.graphNode.getURI());
    }

    @Override
    protected boolean _performAdd(Triple t) {
        if (Quad.isQuadUnionGraph(this.graphNode)) {
            throw new TDBException("Can't add a triple to the RDF merge of all named graphs");
        }
        boolean changed = Quad.isDefaultGraph(this.graphNode) ? this.dataset.getTripleTable().add(t) : this.dataset.getQuadTable().add(this.graphNode, t);
        if (!changed) {
            this.duplicate(t);
        }
        return changed;
    }

    @Override
    protected boolean _performDelete(Triple t) {
        if (Quad.isQuadUnionGraph(this.graphNode)) {
            throw new TDBException("Can't delete triple from the RDF merge of all named graphs");
        }
        if (Quad.isDefaultGraph(this.graphNode)) {
            return this.dataset.getTripleTable().delete(t);
        }
        return this.dataset.getQuadTable().delete(this.graphNode, t);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        if (Quad.isDefaultGraph(this.graphNode)) {
            return this.graphBaseFindWorker(this.getDataset().getTripleTable(), m);
        }
        return this.graphBaseFindWorker(this.getDataset(), this.graphNode, m);
    }

    protected Iterator<Tuple<NodeId>> countThis() {
        NodeId gn = this.getGraphNodeId();
        Tuple<NodeId> t = Tuple.create(gn, null, null, null);
        Iterator<Tuple<NodeId>> iter = this.dataset.getQuadTable().getNodeTupleTable().getTupleTable().getIndex(0).find(t);
        return iter;
    }

    public final NodeId getGraphNodeId() {
        if (this.graphNodeId == null) {
            this.graphNodeId = this.dataset.getQuadTable().getNodeTupleTable().getNodeTable().getAllocateNodeId(this.graphNode);
        }
        return this.graphNodeId;
    }

    @Override
    public Tuple<Node> asTuple(Triple triple) {
        return Tuple.create(this.getGraphNode(), triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    @Override
    protected final Logger getLog() {
        return log;
    }

    @Override
    public NodeTupleTable getNodeTupleTable() {
        if (this.graphNode == null || Quad.isDefaultGraph(this.graphNode)) {
            return this.dataset.getTripleTable().getNodeTupleTable();
        }
        return this.dataset.getQuadTable().getNodeTupleTable();
    }

    @Override
    public final void close() {
        this.sync(true);
    }

    @Override
    public void sync(boolean force) {
        this.dataset.sync(force);
    }

    @Override
    public String toString() {
        return Utils.className(this) + ":<" + this.graphNode + ">";
    }
}

