/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.store;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphCaching;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.DatasetPrefixStorage;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import com.hp.hpl.jena.tdb.store.GraphNamedTDB;
import com.hp.hpl.jena.tdb.store.GraphTDB;
import com.hp.hpl.jena.tdb.store.GraphTriplesTDB;
import com.hp.hpl.jena.tdb.store.NodeId;
import com.hp.hpl.jena.tdb.store.QuadTable;
import com.hp.hpl.jena.tdb.store.TripleTable;
import com.hp.hpl.jena.tdb.sys.TDBMaker;
import com.hp.hpl.jena.update.GraphStore;
import java.util.Iterator;
import java.util.Properties;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.PropertyUtils;
import org.openjena.atlas.lib.Sync;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetGraphTDB
extends DatasetGraphCaching
implements DatasetGraph,
Sync,
Closeable,
GraphStore {
    private TripleTable tripleTable;
    private QuadTable quadTable;
    private DatasetPrefixStorage prefixes;
    private final ReorderTransformation transform;
    private final Location location;
    private final Properties config;
    private GraphTDB effectiveDefaultGraph;
    private boolean closed = false;
    private static Transform<Tuple<NodeId>, NodeId> project0 = new Transform<Tuple<NodeId>, NodeId>(){

        @Override
        public NodeId convert(Tuple<NodeId> item) {
            return item.get(0);
        }
    };

    public DatasetGraphTDB(TripleTable tripleTable, QuadTable quadTable, DatasetPrefixStorage prefixes, ReorderTransformation transform, Location location, Properties config) {
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
        this.prefixes = prefixes;
        this.transform = transform;
        this.location = location;
        this.config = config;
        this.effectiveDefaultGraph = this.getDefaultGraphTDB();
    }

    protected DatasetGraphTDB(DatasetGraphTDB other) {
        this(other.tripleTable, other.quadTable, other.prefixes, other.transform, other.location, other.config);
    }

    public DatasetGraphTDB duplicate() {
        return new DatasetGraphTDB(this.tripleTable, this.quadTable, this.prefixes, this.transform, this.location, this.config);
    }

    public QuadTable getQuadTable() {
        return this.quadTable;
    }

    public TripleTable getTripleTable() {
        return this.tripleTable;
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        return DatasetGraphTDB.triples2quadsDftGraph(this.getTripleTable().find(s, p, o));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        return this.getQuadTable().find(g, s, p, o);
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        return this.getQuadTable().find(Node.ANY, s, p, o);
    }

    protected static Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return DatasetGraphTDB.triples2quads(Quad.tripleInQuad, iter);
    }

    @Override
    protected void addToDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().add(s, p, o);
    }

    @Override
    protected void addToNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().add(g, s, p, o);
    }

    @Override
    protected void deleteFromDftGraph(Node s, Node p, Node o) {
        this.getTripleTable().delete(s, p, o);
    }

    @Override
    protected void deleteFromNamedGraph(Node g, Node s, Node p, Node o) {
        this.getQuadTable().delete(g, s, p, o);
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        NodeId graphNodeId = this.quadTable.getNodeTupleTable().getNodeTable().getNodeIdForNode(graphNode);
        if (NodeId.doesNotExist(graphNodeId)) {
            return false;
        }
        Tuple<NodeId> pattern = Tuple.create(graphNodeId, null, null, null);
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().find(pattern);
        boolean result = x.hasNext();
        return result;
    }

    public GraphTDB getDefaultGraphTDB() {
        return (GraphTDB)this.getDefaultGraph();
    }

    public GraphTDB getGraphTDB(Node graphNode) {
        return (GraphTDB)this.getGraph(graphNode);
    }

    @Override
    protected void _close() {
        this.tripleTable.close();
        this.quadTable.close();
        this.prefixes.close();
        this.tripleTable = null;
        this.quadTable = null;
        this.prefixes = null;
        TDBMaker.releaseDataset(this);
    }

    @Override
    protected boolean _containsGraph(Node graphNode) {
        NodeId graphNodeId = this.quadTable.getNodeTupleTable().getNodeTable().getNodeIdForNode(graphNode);
        Tuple<NodeId> pattern = Tuple.create(graphNodeId, null, null, null);
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().find(pattern);
        boolean result = x.hasNext();
        return result;
    }

    @Override
    protected Graph _createDefaultGraph() {
        return new GraphTriplesTDB(this, this.tripleTable, this.prefixes);
    }

    @Override
    protected Graph _createNamedGraph(Node graphNode) {
        return new GraphNamedTDB(this, graphNode);
    }

    public void setEffectiveDefaultGraph(GraphTDB g) {
        this.effectiveDefaultGraph = g;
    }

    public GraphTDB getEffectiveDefaultGraph() {
        return this.effectiveDefaultGraph;
    }

    public Properties getConfig() {
        return this.config;
    }

    public String getConfigValue(String key) {
        if (this.config == null) {
            return null;
        }
        return this.config.getProperty(key);
    }

    public int getConfigValueAsInt(String key, int dftValue) {
        if (this.config == null) {
            return dftValue;
        }
        return PropertyUtils.getPropertyAsInteger(this.config, key, dftValue);
    }

    public ReorderTransformation getTransform() {
        return this.transform;
    }

    public DatasetPrefixStorage getPrefixes() {
        return this.prefixes;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        Iterator<Tuple<NodeId>> x = this.quadTable.getNodeTupleTable().getTupleTable().getIndex(0).all();
        Iter<NodeId> z = Iter.iter(x).map(project0).distinct();
        return NodeLib.nodes(this.quadTable.getNodeTupleTable().getNodeTable(), z);
    }

    @Override
    public long size() {
        return Iter.count(this.listGraphNodes());
    }

    @Override
    public boolean isEmpty() {
        return this.getTripleTable().isEmpty() && this.getQuadTable().isEmpty();
    }

    public void clear() {
        this.getTripleTable().clearTriples();
        this.getQuadTable().clearQuads();
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public void sync() {
        this.sync(true);
    }

    @Override
    public void sync(boolean force) {
        this.tripleTable.sync(force);
        this.quadTable.sync(force);
        this.prefixes.sync(force);
    }

    @Override
    public void startRequest() {
    }

    @Override
    public void finishRequest() {
        this.sync(true);
    }

    @Override
    public Dataset toDataset() {
        return new DatasetImpl(this);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        Graph g = this.getGraph(graphName);
        g.getBulkUpdateHandler().add(graph);
    }

    @Override
    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("Can't set default graph via GraphStore on a TDB-backed dataset");
    }
}

