/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.solver;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.tdb.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.nodetable.NodeTupleTable;
import com.hp.hpl.jena.tdb.solver.BindingNodeId;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Action;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.iterator.RepeatApplyIterator;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StageMatchTuple
extends RepeatApplyIterator<BindingNodeId> {
    private final NodeTupleTable nodeTupleTable;
    private final Tuple<Node> patternTuple;
    private final ExecutionContext execCxt;
    private boolean anyGraphs;
    private Filter<Tuple<NodeId>> filter;
    private static Action<Tuple<NodeId>> quadsToTriples = new Action<Tuple<NodeId>>(){

        @Override
        public void apply(Tuple<NodeId> item) {
            item.tuple()[0] = NodeId.NodeIdAny;
        }
    };
    private static Transform<Tuple<NodeId>, Tuple<NodeId>> projectToTriples = new Transform<Tuple<NodeId>, Tuple<NodeId>>(){

        @Override
        public Tuple<NodeId> convert(Tuple<NodeId> item) {
            Tuple<NodeId> t2 = Tuple.create(NodeId.NodeIdAny, item.get(1), item.get(2), item.get(3));
            return t2;
        }
    };

    public StageMatchTuple(NodeTupleTable nodeTupleTable, Iterator<BindingNodeId> input, Tuple<Node> tuple, boolean anyGraphs, Filter<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        super(input);
        this.filter = filter;
        this.nodeTupleTable = nodeTupleTable;
        this.patternTuple = tuple;
        this.execCxt = execCxt;
        this.anyGraphs = anyGraphs;
    }

    public static void prepare(NodeTable nodeTable, Tuple<Node> patternTuple, BindingNodeId input, NodeId[] ids, Var[] var) {
        for (int i = 0; i < patternTuple.size(); ++i) {
            Node n = patternTuple.get(i);
            NodeId nId = StageMatchTuple.idFor(nodeTable, input, n);
            if (NodeId.doesNotExist(nId)) {
                new NullIterator();
            }
            ids[i] = nId;
            if (nId != null) continue;
            var[i] = StageMatchTuple.asVar(n);
        }
    }

    @Override
    protected Iterator<BindingNodeId> makeNextStage(final BindingNodeId input) {
        NodeId[] ids = new NodeId[this.patternTuple.size()];
        final Var[] var = new Var[this.patternTuple.size()];
        StageMatchTuple.prepare(this.nodeTupleTable.getNodeTable(), this.patternTuple, input, ids, var);
        Iterator<Tuple<NodeId>> iterMatches = this.nodeTupleTable.getTupleTable().find(Tuple.create(ids));
        if (this.filter != null) {
            iterMatches = Iter.filter(iterMatches, this.filter);
        }
        if (this.anyGraphs) {
            iterMatches = Iter.operate(iterMatches, quadsToTriples);
            iterMatches = Iter.distinct(iterMatches);
        }
        Transform<Tuple<NodeId>, BindingNodeId> binder = new Transform<Tuple<NodeId>, BindingNodeId>(){

            @Override
            public BindingNodeId convert(Tuple<NodeId> tuple) {
                BindingNodeId output = new BindingNodeId(input);
                for (int i = 0; i < var.length; ++i) {
                    Var v = var[i];
                    if (v == null) continue;
                    NodeId id = tuple.get(i);
                    if (StageMatchTuple.reject(output, v, id)) {
                        return null;
                    }
                    output.put(v, id);
                }
                return output;
            }
        };
        return Iter.iter(iterMatches).map(binder).removeNulls();
    }

    private static Iterator<Tuple<NodeId>> print(Iterator<Tuple<NodeId>> iter) {
        if (!iter.hasNext()) {
            System.err.println("<empty>");
        } else {
            List<Tuple<NodeId>> r = Iter.toList(iter);
            String str2 = Iter.asString(r, "\n");
            System.err.println(str2);
            iter = Iter.iter(r);
        }
        return iter;
    }

    private static boolean reject(BindingNodeId output, Var var, NodeId value) {
        if (!output.containsKey(var)) {
            return false;
        }
        return !((NodeId)output.get(var)).equals(value);
    }

    private static Var asVar(Node node) {
        if (Var.isVar(node)) {
            return Var.alloc(node);
        }
        return null;
    }

    private static NodeId idFor(NodeTable nodeTable, BindingNodeId input, Node node) {
        if (Var.isVar(node)) {
            NodeId n = (NodeId)input.get(Var.alloc(node));
            return n;
        }
        return nodeTable.getNodeIdForNode(node);
    }
}

